/* JS function for copilot-project-history.html */
$(document).ready(function(){
    // sort table
    var listViewTable = $(".copilot-pool table.history-view");

    // add parser through the tablesorter addParser method for Duration days
    $.tablesorter.addParser({
        id: 'duration',
        is: function(s) {
            return false;
        },
        format: function(s) {
            return s.replace(/Days/,"");
        },
        type: 'numeric'
    }); 

    listViewTable.tablesorter({
        headers: {
            3: { sorter:'duration'},
            4: { sorter:'duration'}
        }
    }); 

    //assign the sortEnd event
    listViewTable.bind("sortEnd",function() {
         $.each(listViewTable.find("tbody tr"),function(index,item){
               if(index%2 == 1){
                   $(item).addClass("even");
               }else{
                   $(item).removeClass("even");
               }
         })
    });

   // bind sort function for two sub titles  
   listViewTable.find("#contests-planned").click(function(event){
       var sorting = null;
       if(!$(this).data("status")){
           $(this).data("status","ascending");
       }
       if($(this).data("status") == "ascending"){                // it is ascending
            var sorting = [[1,0]];
            $(this).data("status","descending");
       }else{                                         // it is  descending
            var sorting = [[1,1]];
            $(this).data("status","ascending");
       } 
        listViewTable.trigger("sorton",[sorting]);
        event.stopPropagation();
   })
   listViewTable.find("#duration-planned").click(function(event){
        var sorting = null;
       if(!$(this).data("status")){
           $(this).data("status","ascending");
       }
       if($(this).data("status") == "ascending"){                // it is ascending
            var sorting = [[3,0]];
            $(this).data("status","descending");
       }else{                                         // it is  descending
            var sorting = [[3,1]];
            $(this).data("status","ascending");
       } 
       listViewTable.trigger("sorton",[sorting]);
       event.stopPropagation();
   })

    // bind sort function for select
    $(".copilot-pool select#history-sort").change(function(){
        var value = $(this).val();
        switch(value){
            case "1":
                var sorting = [[4,0]];
                listViewTable.trigger("sorton",[sorting]);
                break;
         case "2":
                var sorting = [[0,0]];
                listViewTable.trigger("sorton",[sorting]);
                break;
         case "3":
                var sorting = [[7,0]];
                listViewTable.trigger("sorton",[sorting]);
                break;
        }
    })
 });
 