/* js functions for copilot-project-detail.html */

// define google visualization charts
google.load("visualization", "1", {packages:["corechart"]});
google.setOnLoadCallback(drawColumnChart1);
google.setOnLoadCallback(drawColumnChart2);
google.setOnLoadCallback(drawColumnChart3);
function drawColumnChart1() {
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'type');
    data.addColumn('number', 'Planned');
    data.addColumn('number', 'Real');
    data.addRows(barchart1.length);
    $.each(barchart1,function(index,item){
        data.setValue(index, 0, item.name);
        data.setValue(index, 1, item.planned);
        data.setValue(index, 2, item.real);
    }) 
    var chart = new google.visualization.ColumnChart($("#chart1 .chart")[0]);
    chart.draw(data, {
        width: 250,
        height: 250,
        colors:["#D00000","#000000"],
        legend:'none',
        min:0,
        tooltipFontSize:11,
        fontSize:12
    });
}
function drawColumnChart2() {
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'type');
    data.addColumn('number', 'Planned Duration');
    data.addColumn('number', 'Real Duration');
    data.addRows(barchart2.length);
    $.each(barchart2,function(index,item){
        data.setValue(index, 0, item.name);
        data.setValue(index, 1, item.planned);
        data.setValue(index, 2, item.real);
    });

    var chart = new google.visualization.BarChart($("#chart2 .chart")[0]);
    chart.draw(data, {
        width: 300,
        height: 250,
        colors:["#D00000","#000000"],
        legend:'none',
        min:0,
        hAxis:{title:'Month'},
        vAxis:{title:'Planned VS Real'},
        fontSize:12,
        titleFontSize:11
    });
}
function drawColumnChart3() {
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'type');
    data.addColumn('number', 'Planned Contests');
    data.addColumn('number', 'Real Contests');
    data.addColumn('number', 'Reposts');
    data.addColumn('number', 'Failures');
    data.addRows(barchart3.length);
    $.each(barchart3,function(index,item){
        data.setValue(index, 0, item.name);
        data.setValue(index, 1, item.plannedContests);
        data.setValue(index, 2, item.realContests);
        data.setValue(index, 3, item.reposts);
        data.setValue(index, 4, item.failures);
    });

    var chart = new google.visualization.ColumnChart($("#chart3 .chart")[0]);
    chart.draw(data, {
        width: 320,
        height: 280,
        title: 'No. of Contests', 
        colors:["#D00000","#000000","#666666","#B2B2B2"],
        legend:'bottom',
        min:0,
        tooltipFontSize:11,
        fontSize:12
     });
}

$(document).ready(function(){
    //
    var controllers = $(".palisade div.controller");
    var contents = $(".palisade .right-area table");
    controllers.click(function(){
        $(this).blur();
        contents.hide();
        controllers.removeClass("active");
        $(this).addClass("active");
        $(".palisade .right-area table." + $(this).attr("id")).show();
        return false;
    })
    $(controllers[1]).trigger("click"); 

})



