/* js functions for copilot-profile.html */

// define google visualization charts
google.load("visualization", "1", {packages:["corechart"]});
google.setOnLoadCallback(drawPieChart); 
google.setOnLoadCallback(drawColumnChart);
function drawPieChart() {
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'Task');
    data.addColumn('number', 'The amount of the tasks');
    data.addRows(piechart.length);
    $.each(piechart,function(index,item){
        data.setValue(index, 0, item.name);
        data.setValue(index, 1, item.value);
    }) 

    var chart = new google.visualization.PieChart($(".pie-chart")[0]);

    chart.draw(data, {
        width:300,
        height: 300,
        title: 'Overall Contests',
        titleFontSize:14,
        legend:'none',
        colors:['#D1D1D1','#B2B2B2','#666666','#A60000','#DA0000','#FF4A00','#FF9000','#FEC228','#FFD97A','#FFE6A8']
    });

     google.visualization.events.addListener(chart, 'ready', function(){
        
     });

}

function drawColumnChart() {
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'type');
    data.addColumn('number', 'Planned Contests');
    data.addColumn('number', 'Real Contests');
    data.addColumn('number', 'Reposts');
    data.addColumn('number', 'Failures'); 
    data.addRows(barchart.length);
    $.each(barchart,function(index,item){
        data.setValue(index, 0, item.name);
        data.setValue(index, 1, item.plannedContests);
        data.setValue(index, 2, item.realContests);
        data.setValue(index, 3, item.reposts);
        data.setValue(index, 4, item.failures);
    }) 

    var chart = new google.visualization.ColumnChart($(".column-chart")[0]);
    var width = $("#copilot-profile").width();
    chart.draw(data, {
        width: width,
        height: 250,
        title: 'No. of Contests',
        titleColor:'#333333',
        colors:["#D00000","#000000","#666666","#B2B2B2"],
        legend:'none',
        fontSize:11,
        titleFontSize:12
       });
}

$(document).ready(function(){
    //
    var controllers = $(".palisade div.controller");
    var contents = $(".palisade .right-area table");
    controllers.click(function(){
        $(this).blur();
        contents.hide();
        controllers.removeClass("active"); 
        $(this).addClass("active");
        $(".palisade .right-area table." + $(this).attr("id")).show();
        return false;
    })
    $(controllers[1]).trigger("click");

    $("#copilot-profile .help").tooltip({
        tip: ".tooltip",
        direction: 'up' ,
        opacity:0.97,
        onBeforeShow : function(){

        },
        effect: 'slide',
        position: "top ",// tweak the position
        offset: [10,2]
    }).dynamic({ right: { direction: 'right', bounce: true } });    
})



