package com.topcoder.direct.services.copilot.model;

import java.util.Date;

/**
 * This class is a container for information about a single planned contest. It is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public class PlannedContest extends IdentifiableEntity {
    /**
     * The name of the planned contest. Can be any value. Has getter and setter.
     */
    private String name;

    /**
     * The description of the contest. Can be any value. Has getter and setter.
     */
    private String description;

    /**
     * The ID of the project category. Can be any value. Has getter and setter.
     */
    private long projectCategoryId;

    /**
     * The ID of the copilot project plan. Can be any value. Has getter and setter.
     */
    private long copilotProjectPlanId;

    /**
     * The start date of the contest. Can be any value. Has getter and setter.
     */
    private Date startDate;

    /**
     * The end date of the contest. Can be any value. Has getter and setter.
     */
    private Date endDate;

    /**
     * Creates an instance of PlannedContest.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    public PlannedContest() {
    }

    /**
     * Retrieves the name of the planned contest.
     * 
     * Returns:
     * the name of the planned contest
     * @return the name of the planned contest
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of the planned contest.
     * 
     * Parameters:
     * name - the name of the planned contest
     * @param name the name of the planned contest
     */
    public void setName(String name) {
        this.name=name;
    }

    /**
     * Retrieves the description of the contest.
     * 
     * Returns:
     * the description of the contest
     * @return the description of the contest
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the description of the contest.
     * 
     * Parameters:
     * description - the description of the contest
     * @param description the description of the contest
     */
    public void setDescription(String description) {
        this.description=description;
    }

    /**
     * Retrieves the ID of the project category.
     * 
     * Returns:
     * the ID of the project category
     * @return the ID of the project category
     */
    public long getProjectCategoryId() {
        return projectCategoryId;
    }

    /**
     * Sets the ID of the project category.
     * 
     * Parameters:
     * projectCategoryId - the ID of the project category
     * @param projectCategoryId the ID of the project category
     */
    public void setProjectCategoryId(long projectCategoryId) {
        this.projectCategoryId=projectCategoryId;
    }

    /**
     * Retrieves the ID of the copilot project plan.
     * 
     * Returns:
     * the ID of the copilot project plan
     * @return the ID of the copilot project plan
     */
    public long getCopilotProjectPlanId() {
        return copilotProjectPlanId;
    }

    /**
     * Sets the ID of the copilot project plan.
     * 
     * Parameters:
     * copilotProjectPlanId - the ID of the copilot project plan
     * @param copilotProjectPlanId the ID of the copilot project plan
     */
    public void setCopilotProjectPlanId(long copilotProjectPlanId) {
        this.copilotProjectPlanId=copilotProjectPlanId;
    }

    /**
     * Retrieves the start date of the contest.
     * 
     * Returns:
     * the start date of the contest
     * @return the start date of the contest
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * Sets the start date of the contest.
     * 
     * Parameters:
     * startDate - the start date of the contest
     * @param startDate the start date of the contest
     */
    public void setStartDate(Date startDate) {
        this.startDate=startDate;
    }

    /**
     * Retrieves the end date of the contest.
     * 
     * Returns:
     * the end date of the contest
     * @return the end date of the contest
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * Sets the end date of the contest.
     * 
     * Parameters:
     * endDate - the end date of the contest
     * @param endDate the end date of the contest
     */
    public void setEndDate(Date endDate) {
        this.endDate=endDate;
    }
}

