package com.topcoder.direct.services.copilot.model;

/**
 * This is a base class for all lookup entities. It's assumed that each lookup entity has a name field. This class is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public abstract class LookupEntity extends IdentifiableEntity {
    /**
     * The name associated with the lookup entity. Can be any value. Has getter and setter.
     */
    private String name;

    /**
     * Creates an instance of LookupEntity.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    protected LookupEntity() {
    }

    /**
     * Retrieves the name associated with the lookup entity.
     * 
     * Returns:
     * the name associated with the lookup entity
     * @return the name associated with the lookup entity
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name associated with the lookup entity.
     * 
     * Parameters:
     * name - the name associated with the lookup entity
     * @param name the name associated with the lookup entity
     */
    public void setName(String name) {
        this.name=name;
    }
}

