package com.topcoder.direct.services.copilot.model;

import java.io.Serializable;
import java.util.Date;

/**
 * This is a base class for all entities that have ID and auditing fields. It is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public abstract class IdentifiableEntity implements Serializable {
    /**
     * The ID of the entity. Can be any value. Has getter and setter.
     */
    private long id;

    /**
     * The user that created the entity. Can be any value. Has getter and setter.
     */
    private String createUser;

    /**
     * The creation date of the entity. Can be any value. Has getter and setter.
     */
    private Date createDate;

    /**
     * The last user that modified the entity. Can be any value. Has getter and setter.
     */
    private String modifyUser;

    /**
     * The last modification date of the entity. Can be any value. Has getter and setter.
     */
    private Date modifyDate;

    /**
     * Creates an instance of IdentifiableEntity.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    protected IdentifiableEntity() {
    }

    /**
     * Retrieves the ID of the entity.
     * 
     * Returns:
     * the ID of the entity
     * @return the ID of the entity
     */
    public long getId() {
        return id;
    }

    /**
     * Sets the ID of the entity.
     * 
     * Parameters:
     * id - the ID of the entity
     * @param id the ID of the entity
     */
    public void setId(long id) {
        this.id=id;
    }

    /**
     * Retrieves the user that created the entity.
     * 
     * Returns:
     * the user that created the entity
     * @return the user that created the entity
     */
    public String getCreateUser() {
        return createUser;
    }

    /**
     * Sets the user that created the entity.
     * 
     * Parameters:
     * createUser - the user that created the entity
     * @param createUser the user that created the entity
     */
    public void setCreateUser(String createUser) {
        this.createUser=createUser;
    }

    /**
     * Retrieves the creation date of the entity.
     * 
     * Returns:
     * the creation date of the entity
     * @return the creation date of the entity
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * Sets the creation date of the entity.
     * 
     * Parameters:
     * createDate - the creation date of the entity
     * @param createDate the creation date of the entity
     */
    public void setCreateDate(Date createDate) {
        this.createDate=createDate;
    }

    /**
     * Retrieves the last user that modified the entity.
     * 
     * Returns:
     * the last user that modified the entity
     * @return the last user that modified the entity
     */
    public String getModifyUser() {
        return modifyUser;
    }

    /**
     * Sets the last user that modified the entity.
     * 
     * Parameters:
     * modifyUser - the last user that modified the entity
     * @param modifyUser the last user that modified the entity
     */
    public void setModifyUser(String modifyUser) {
        this.modifyUser=modifyUser;
    }

    /**
     * Retrieves the last modification date of the entity.
     * 
     * Returns:
     * the last modification date of the entity
     * @return the last modification date of the entity
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * Sets the last modification date of the entity.
     * 
     * Parameters:
     * modifyDate - the last modification date of the entity
     * @param modifyDate the last modification date of the entity
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate=modifyDate;
    }
}

