package com.topcoder.direct.services.copilot.model;

import java.util.Set;

/**
 * This class is a container for information about a single copilot project plan. It is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public class CopilotProjectPlan extends IdentifiableEntity {
    /**
     * The planned duration of the copilot project in days. Can be any value. Has getter and setter.
     */
    private int plannedDuration;

    /**
     * The planned number of bug races. Can be any value. Has getter and setter.
     */
    private int plannedBugRaces;

    /**
     * The ID of the copilot project. Can be any value. Has getter and setter.
     */
    private long copilotProjectId;

    /**
     * The planned contests for the copilot project. Can be any value. Has getter and setter.
     */
    private Set<PlannedContest> plannedContests;

    /**
     * Creates an instance of CopilotProjectPlan.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    public CopilotProjectPlan() {
    }

    /**
     * Retrieves the planned duration of the copilot project in days.
     * 
     * Returns:
     * the planned duration of the copilot project in days
     * @return the planned duration of the copilot project in days
     */
    public int getPlannedDuration() {
        return plannedDuration;
    }

    /**
     * Sets the planned duration of the copilot project in days.
     * 
     * Parameters:
     * plannedDuration - the planned duration of the copilot project in days
     * @param plannedDuration the planned duration of the copilot project in days
     */
    public void setPlannedDuration(int plannedDuration) {
        this.plannedDuration=plannedDuration;
    }

    /**
     * Retrieves the planned number of bug races.
     * 
     * Returns:
     * the planned number of bug races
     * @return the planned number of bug races
     */
    public int getPlannedBugRaces() {
        return plannedBugRaces;
    }

    /**
     * Sets the planned number of bug races.
     * 
     * Parameters:
     * plannedBugRaces - the planned number of bug races
     * @param plannedBugRaces the planned number of bug races
     */
    public void setPlannedBugRaces(int plannedBugRaces) {
        this.plannedBugRaces=plannedBugRaces;
    }

    /**
     * Retrieves the ID of the copilot project.
     * 
     * Returns:
     * the ID of the copilot project
     * @return the ID of the copilot project
     */
    public long getCopilotProjectId() {
        return copilotProjectId;
    }

    /**
     * Sets the ID of the copilot project.
     * 
     * Parameters:
     * copilotProjectId - the ID of the copilot project
     * @param copilotProjectId the ID of the copilot project
     */
    public void setCopilotProjectId(long copilotProjectId) {
        this.copilotProjectId=copilotProjectId;
    }

    /**
     * Retrieves the planned contests for the copilot project.
     * 
     * Returns:
     * the planned contests for the copilot project
     * @return the planned contests for the copilot project
     */
    public Set<PlannedContest> getPlannedContests() {
        return plannedContests;
    }

    /**
     * Sets the planned contests for the copilot project.
     * 
     * Parameters:
     * plannedContests - the planned contests for the copilot project
     * @param plannedContests the planned contests for the copilot project
     */
    public void setPlannedContests(Set<PlannedContest> plannedContests) {
        this.plannedContests=plannedContests;
    }
}

