package com.topcoder.direct.services.copilot.model;


/**
 * This class is a container for a single copilot project detail. It is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public class CopilotProjectInfo extends IdentifiableEntity {
    /**
     * The copilot project info type. Can be any value. Has getter and setter.
     */
    private CopilotProjectInfoType infoType;

    /**
     * The ID of the copilot project. Can be any value. Has getter and setter.
     */
    private long copilotProjectId;

    /**
     * The value for the project info. Can be any value. Has getter and setter.
     */
    private String value;

    /**
     * Creates an instance of CopilotProjectInfo.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    public CopilotProjectInfo() {
    }

    /**
     * Retrieves the copilot project info type.
     * 
     * Returns:
     * the copilot project info type
     * @return the copilot project info type
     */
    public CopilotProjectInfoType getInfoType() {
        return infoType;
    }

    /**
     * Sets the copilot project info type.
     * 
     * Parameters:
     * infoType - the copilot project info type
     * @param infoType the copilot project info type
     */
    public void setInfoType(CopilotProjectInfoType infoType) {
        this.infoType=infoType;
    }

    /**
     * Retrieves the ID of the copilot project.
     * 
     * Returns:
     * the ID of the copilot project
     * @return the ID of the copilot project
     */
    public long getCopilotProjectId() {
        return copilotProjectId;
    }

    /**
     * Sets the ID of the copilot project.
     * 
     * Parameters:
     * copilotProjectId - the ID of the copilot project
     * @param copilotProjectId the ID of the copilot project
     */
    public void setCopilotProjectId(long copilotProjectId) {
        this.copilotProjectId=copilotProjectId;
    }

    /**
     * Retrieves the value for the project info.
     * 
     * Returns:
     * the value for the project info
     * @return the value for the project info
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value for the project info.
     * 
     * Parameters:
     * value - the value for the project info
     * @param value the value for the project info
     */
    public void setValue(String value) {
        this.value=value;
    }
}

