package com.topcoder.direct.services.copilot.model;

import java.util.Date;
import java.util.Set;

/**
 * This class is a container for information about a single copilot project. It is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public class CopilotProject extends IdentifiableEntity {
    /**
     * The ID of the copilot profile associated with this project. Can be any value. Has getter and setter.
     */
    private long copilotProfileId;

    /**
     * The name of the copilot project. Can be any value. Has getter and setter.
     */
    private String name;

    /**
     * The ID of the TC direct project associated with this copilot project. Can be any value. Has getter and setter.
     */
    private long tcDirectProjectId;

    /**
     * The copilot type. Can be any value. Has getter and setter.
     */
    private CopilotType copilotType;

    /**
     * The copilot project status. Can be any value. Has getter and setter.
     */
    private CopilotProjectStatus status;

    /**
     * The customer feedback for the copilot project. Can be any value. Has getter and setter.
     */
    private String customerFeedback;

    /**
     * The customer rating for the copilot project. Can be any value. Has getter and setter.
     */
    private Float customerRating;

    /**
     * The feedback of the PM for the copilot project. Can be any value. Has getter and setter.
     */
    private String pmFeedback;

    /**
     * The rating of the PM for the copilot project. Can be any value. Has getter and setter.
     */
    private Float pmRating;

    /**
     * The flag indicating whether the copilot project is a private one. Can be any value. Has getter and setter.
     */
    private boolean privateProject;

    /**
     * The additional project details. Can be any value. Has getter and setter.
     */
    private Set<CopilotProjectInfo> projectInfos;

    /**
     * The completion date of the copilot project. Can be any value. Has getter and setter.
     */
    private Date completionDate;

    /**
     * Creates an instance of CopilotProject.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    public CopilotProject() {
    }

    /**
     * Retrieves the ID of the copilot profile associated with this project.
     * 
     * Returns:
     * the ID of the copilot profile associated with this project
     * @return the ID of the copilot profile associated with this project
     */
    public long getCopilotProfileId() {
        return copilotProfileId;
    }

    /**
     * Sets the ID of the copilot profile associated with this project.
     * 
     * Parameters:
     * copilotProfileId - the ID of the copilot profile associated with this project
     * @param copilotProfileId the ID of the copilot profile associated with this project
     */
    public void setCopilotProfileId(long copilotProfileId) {
        this.copilotProfileId=copilotProfileId;
    }

    /**
     * Retrieves the name of the copilot project.
     * 
     * Returns:
     * the name of the copilot project
     * @return the name of the copilot project
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of the copilot project.
     * 
     * Parameters:
     * name - the name of the copilot project
     * @param name the name of the copilot project
     */
    public void setName(String name) {
    }

    /**
     * Retrieves the ID of the TC direct project associated with this copilot project.
     * 
     * Returns:
     * the ID of the TC direct project associated with this copilot project
     * @return the ID of the TC direct project associated with this copilot project
     */
    public long getTcDirectProjectId() {
        return tcDirectProjectId;
    }

    /**
     * Sets the ID of the TC direct project associated with this copilot project.
     * 
     * Parameters:
     * tcDirectProjectId - the ID of the TC direct project associated with this copilot project
     * @param tcDirectProjectId the ID of the TC direct project associated with this copilot project
     */
    public void setTcDirectProjectId(long tcDirectProjectId) {
        this.tcDirectProjectId=tcDirectProjectId;
    }

    /**
     * Retrieves the copilot type.
     * 
     * Returns:
     * the copilot type
     * @return the copilot type
     */
    public CopilotType getCopilotType() {
        return copilotType;
    }

    /**
     * Sets the copilot type.
     * 
     * Parameters:
     * copilotType - the copilot type
     * @param copilotType the copilot type
     */
    public void setCopilotType(CopilotType copilotType) {
        this.copilotType=copilotType;
    }

    /**
     * Retrieves the copilot project status.
     * 
     * Returns:
     * the copilot project status
     * @return the copilot project status
     */
    public CopilotProjectStatus getStatus() {
        return status;
    }

    /**
     * Sets the copilot project status.
     * 
     * Parameters:
     * status - the copilot project status
     * @param status the copilot project status
     */
    public void setStatus(CopilotProjectStatus status) {
        this.status=status;
    }

    /**
     * Retrieves the customer feedback for the copilot project.
     * 
     * Returns:
     * the customer feedback for the copilot project
     * @return the customer feedback for the copilot project
     */
    public String getCustomerFeedback() {
        return customerFeedback;
    }

    /**
     * Sets the customer feedback for the copilot project.
     * 
     * Parameters:
     * customerFeedback - the customer feedback for the copilot project
     * @param customerFeedback the customer feedback for the copilot project
     */
    public void setCustomerFeedback(String customerFeedback) {
        this.customerFeedback=customerFeedback;
    }

    /**
     * Retrieves the customer rating for the copilot project.
     * 
     * Returns:
     * the customer rating for the copilot project
     * @return the customer rating for the copilot project
     */
    public Float getCustomerRating() {
        return customerRating;
    }

    /**
     * Sets the customer rating for the copilot project.
     * 
     * Parameters:
     * customerRating - the customer rating for the copilot project
     * @param customerRating the customer rating for the copilot project
     */
    public void setCustomerRating(Float customerRating) {
        this.customerRating=customerRating;
    }

    /**
     * Retrieves the feedback of the PM for the copilot project.
     * 
     * Returns:
     * the feedback of the PM for the copilot project
     * @return the feedback of the PM for the copilot project
     */
    public String getPmFeedback() {
        return pmFeedback;
    }

    /**
     * Sets the feedback of the PM for the copilot project.
     * 
     * Parameters:
     * pmFeedback - the feedback of the PM for the copilot project
     * @param pmFeedback the feedback of the PM for the copilot project
     */
    public void setPmFeedback(String pmFeedback) {
        this.pmFeedback=pmFeedback;
    }

    /**
     * Retrieves the rating of the PM for the copilot project.
     * 
     * Returns:
     * the rating of the PM for the copilot project
     * @return the rating of the PM for the copilot project
     */
    public Float getPmRating() {
        return pmRating;
    }

    /**
     * Sets the rating of the PM for the copilot project.
     * 
     * Parameters:
     * pmRating - the rating of the PM for the copilot project
     * @param pmRating the rating of the PM for the copilot project
     */
    public void setPmRating(Float pmRating) {
        this.pmRating=pmRating;
    }

    /**
     * Retrieves the flag indicating whether the copilot project is a private one.
     * 
     * Returns:
     * the flag indicating whether the copilot project is a private one
     * @return the flag indicating whether the copilot project is a private one
     */
    public boolean isPrivateProject() {
        return privateProject;
    }

    /**
     * Sets the flag indicating whether the copilot project is a private one.
     * 
     * Parameters:
     * privateProject - the flag indicating whether the copilot project is a private one
     * @param privateProject the flag indicating whether the copilot project is a private one
     */
    public void setPrivateProject(boolean privateProject) {
        this.privateProject=privateProject;
    }

    /**
     * Retrieves the additional project details.
     * 
     * Returns:
     * the additional project details
     * @return the additional project details
     */
    public Set<CopilotProjectInfo> getProjectInfos() {
        return projectInfos;
    }

    /**
     * Sets the additional project details.
     * 
     * Parameters:
     * projectInfos - the additional project details
     * @param projectInfos the additional project details
     */
    public void setProjectInfos(Set<CopilotProjectInfo> projectInfos) {
        this.projectInfos=projectInfos;
    }

    /**
     * Retrieves the completion date of the copilot project.
     * 
     * Returns:
     * the completion date of the copilot project
     * @return the completion date of the copilot project
     */
    public Date getCompletionDate() {
        return completionDate;
    }

    /**
     * Sets the completion date of the copilot project.
     * 
     * Parameters:
     * completionDate - the completion date of the copilot project
     * @param completionDate the completion date of the copilot project
     */
    public void setCompletionDate(Date completionDate) {
        this.completionDate=completionDate;
    }
}

