package com.topcoder.direct.services.copilot.model;

import java.lang.*;

/**
 * This class is a container for a single copilot profile detail. It is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public class CopilotProfileInfo extends IdentifiableEntity {
    /**
     * The copilot profile info type. Can be any value. Has getter and setter.
     */
    private CopilotProfileInfoType infoType;

    /**
     * The ID of the copilot profile. Can be any value. Has getter and setter.
     */
    private long copilotProfileId;

    /**
     * The value for the profile info. Can be any value. Has getter and setter.
     */
    private String value;

    /**
     * Creates an instance of CopilotProfileInfo.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    public CopilotProfileInfo() {
    }

    /**
     * Retrieves the copilot profile info type.
     * 
     * Returns:
     * the copilot profile info type
     * @return the copilot profile info type
     */
    public CopilotProfileInfoType getInfoType() {
        return infoType;
    }

    /**
     * Sets the copilot profile info type.
     * 
     * Parameters:
     * infoType - the copilot profile info type
     * @param infoType the copilot profile info type
     */
    public void setInfoType(CopilotProfileInfoType infoType) {
        this.infoType=infoType;
    }

    /**
     * Retrieves the ID of the copilot profile.
     * 
     * Returns:
     * the ID of the copilot profile
     * @return the ID of the copilot profile
     */
    public long getCopilotProfileId() {
        return copilotProfileId;
    }

    /**
     * Sets the ID of the copilot profile.
     * 
     * Parameters:
     * copilotProfileId - the ID of the copilot profile
     * @param copilotProfileId the ID of the copilot profile
     */
    public void setCopilotProfileId(long copilotProfileId) {
        this.copilotProfileId=copilotProfileId;
    }

    /**
     * Retrieves the value for the profile info.
     * 
     * Returns:
     * the value for the profile info
     * @return the value for the profile info
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value for the profile info.
     * 
     * Parameters:
     * value - the value for the profile info
     * @param value the value for the profile info
     */
    public void setValue(String value) {
        this.value=value;
    }
}

