package com.topcoder.direct.services.copilot.model;

import java.util.Date;
import java.util.Set;

/**
 * This class is a container for information about a single copilot profile. It is a simple JavaBean (POJO) that provides getters and setters for all private attributes and performs no argument validation in the setters.
 * 
 * Thread Safety:
 * This class is mutable and not thread safe.
 */
public class CopilotProfile extends IdentifiableEntity {
    /**
     * The ID of the copilot user. Can be any value. Has getter and setter.
     */
    private long userId;

    /**
     * The copilot profile status. Can be any value. Has getter and setter.
     */
    private CopilotProfileStatus status;

    /**
     * The number of suspensions for this copilot. Can be any value. Has getter and setter.
     */
    private int suspensionCount;

    /**
     * The reliability rating of the copilot. Can be any value. Has getter and setter.
     */
    private float reliability;

    /**
     * The activation date of the copilot. Can be any value. Has getter and setter.
     */
    private Date activationDate;

    /**
     * The flag indicating whether copilot earnings can be shown. Can be any value. Has getter and setter.
     */
    private boolean showCopilotEarnings;

    /**
     * The additional profile details. Can be any value. Has getter and setter.
     */
    private Set<CopilotProfileInfo> profileInfos;

    /**
     * Creates an instance of CopilotProfile.
     * 
     * Implementation Notes:
     * Do nothing.
     */
    public CopilotProfile() {
    }

    /**
     * Retrieves the ID of the copilot user.
     * 
     * Returns:
     * the ID of the copilot user
     * @return the ID of the copilot user
     */
    public long getUserId() {
        return userId;
    }

    /**
     * Sets the ID of the copilot user.
     * 
     * Parameters:
     * userId - the ID of the copilot user
     * @param userId the ID of the copilot user
     */
    public void setUserId(long userId) {
        this.userId=userId;
    }

    /**
     * Retrieves the copilot profile status.
     * 
     * Returns:
     * the copilot profile status
     * @return the copilot profile status
     */
    public CopilotProfileStatus getStatus() {
        return status;
    }

    /**
     * Sets the copilot profile status.
     * 
     * Parameters:
     * status - the copilot profile status
     * @param status the copilot profile status
     */
    public void setStatus(CopilotProfileStatus status) {
        this.status=status;
    }

    /**
     * Retrieves the number of suspensions for this copilot.
     * 
     * Returns:
     * the number of suspensions for this copilot
     * @return the number of suspensions for this copilot
     */
    public int getSuspensionCount() {
        return suspensionCount;
    }

    /**
     * Sets the number of suspensions for this copilot.
     * 
     * Parameters:
     * suspensionCount - the number of suspensions for this copilot
     * @param suspensionCount the number of suspensions for this copilot
     */
    public void setSuspensionCount(int suspensionCount) {
        this.suspensionCount=suspensionCount;
    }

    /**
     * Retrieves the reliability rating of the copilot.
     * 
     * Returns:
     * the reliability rating of the copilot
     * @return the reliability rating of the copilot
     */
    public float getReliability() {
        return reliability;
    }

    /**
     * Sets the reliability rating of the copilot.
     * 
     * Parameters:
     * reliability - the reliability rating of the copilot
     * @param reliability the reliability rating of the copilot
     */
    public void setReliability(float reliability) {
        this.reliability=reliability;
    }

    /**
     * Retrieves the activation date of the copilot.
     * 
     * Returns:
     * the activation date of the copilot
     * @return the activation date of the copilot
     */
    public Date getActivationDate() {
        return activationDate;
    }

    /**
     * Sets the activation date of the copilot.
     * 
     * Parameters:
     * activationDate - the activation date of the copilot
     * @param activationDate the activation date of the copilot
     */
    public void setActivationDate(Date activationDate) {
        this.activationDate=activationDate;
    }

    /**
     * Retrieves the flag indicating whether copilot earnings can be shown.
     * 
     * Returns:
     * the flag indicating whether copilot earnings can be shown
     * @return the flag indicating whether copilot earnings can be shown
     */
    public boolean isShowCopilotEarnings() {
        return showCopilotEarnings;
    }

    /**
     * Sets the flag indicating whether copilot earnings can be shown.
     * 
     * Parameters:
     * showCopilotEarnings - the flag indicating whether copilot earnings can be shown
     * @param showCopilotEarnings the flag indicating whether copilot earnings can be shown
     */
    public void setShowCopilotEarnings(boolean showCopilotEarnings) {
        this.showCopilotEarnings=showCopilotEarnings;
    }

    /**
     * Retrieves the additional profile details.
     * 
     * Returns:
     * the additional profile details
     * @return the additional profile details
     */
    public Set<CopilotProfileInfo> getProfileInfos() {
        return profileInfos;
    }

    /**
     * Sets the additional profile details.
     * 
     * Parameters:
     * profileInfos - the additional profile details
     * @param profileInfos the additional profile details
     */
    public void setProfileInfos(Set<CopilotProfileInfo> profileInfos) {
        this.profileInfos=profileInfos;
    }
}

