package com.topcoder.direct.services.copilot.dao;

import java.util.List;

import com.topcoder.direct.services.copilot.model.CopilotProfileStatus;
import com.topcoder.direct.services.copilot.model.CopilotProjectStatus;
import com.topcoder.direct.services.copilot.model.CopilotType;

/**
 * This interface represents a lookup DAO. It provides method for retrieving all copilot profile statuses, copilot project statuses and copilot types from persistence.
 * 
 * Thread Safety:
 * Implementations of this interface must be thread safe.
 */
public interface LookupDAO {
    /**
     * Retrieves all copilot profile statuses from persistence. Returns an empty list if none are found.
     * 
     * Returns:
     * the retrieved copilot profile statuses (not null, doesn't contain null)
     * 
     * Throws:
     * CopilotDAOException if any error occurred
     * @throws CopilotDAOException if any error occurred
     * @return the retrieved copilot profile statuses (not null, doesn't contain null)
     */
    public List<CopilotProfileStatus> getAllCopilotProfileStatuses()throws CopilotDAOException;

    /**
     * Retrieves all copilot project statuses from persistence. Returns an empty list if none are found.
     * 
     * Returns:
     * the retrieved copilot project statuses (not null, doesn't contain null)
     * 
     * Throws:
     * CopilotDAOException if any error occurred
     * @throws CopilotDAOException if any error occurred
     * @return the retrieved copilot project statuses (not null, doesn't contain null)
     */
    public List<CopilotProjectStatus> getAllCopilotProjectStatuses()throws CopilotDAOException;

    /**
     * Retrieves all copilot types from persistence. Returns an empty list if none are found.
     * 
     * Returns:
     * the retrieved copilot types (not null, doesn't contain null)
     * 
     * Throws:
     * CopilotDAOException if any error occurred
     * @throws CopilotDAOException if any error occurred
     * @return the retrieved copilot types (not null, doesn't contain null)
     */
    public List<CopilotType> getAllCopilotTypes()throws CopilotDAOException;
}

