package com.topcoder.direct.services.copilot.dao;

import com.topcoder.direct.services.copilot.model.CopilotProjectPlan;

/**
 * This interface represents a copilot project plan DAO. It extends GenericDAO<CopilotProjectPlan> and provides an additional method for retrieving copilot project plan by the given copilot project ID.
 * 
 * Thread Safety:
 * Implementations of this interface must be thread safe when entities passed to them are used by the caller in thread safe manner.
*/
public interface CopilotProjectPlanDAO extends GenericDAO<CopilotProjectPlan> {
/**
 * Retrieves the copilot project plan of copilot project with the given ID.
 * 
 * Parameters:
 * copilotProjectId - the ID of the copilot project
 * 
 * Returns:
 * the retrieved copilot project plan (or null if copilot project with the given ID doesn't exist or there is no associated plan)
 * 
 * Throws:
 * IllegalArgumentException if copilotProjectId <= 0
 * CopilotDAOException if some other error occurred
 * @throws IllegalArgumentException if copilotProjectId <= 0
 * @throws CopilotDAOException if some other error occurred
 * @param copilotProjectId the ID of the copilot project
 * @return the retrieved copilot project plan (or null if copilot project with the given ID doesn't exist or there is no associated plan)
*/
public CopilotProjectPlan getCopilotProjectPlan(long copilotProjectId)throws CopilotDAOException;
}

