package com.topcoder.direct.services.copilot.dao;

import java.util.List;

import com.topcoder.direct.services.copilot.model.CopilotProject;

/**
 * This interface represents a copilot project DAO. It extends GenericDAO<CopilotProject> and provides an additional method for retrieving a list of copilot projects for the specified copilot.
 * 
 * Thread Safety:
 * Implementations of this interface must be thread safe when entities passed to them are used by the caller in thread safe manner.
*/
public interface CopilotProjectDAO extends GenericDAO<CopilotProject> {
/**
 * Retrieves the copilot projects for the copilot with the specified profile ID. Returns an empty list if the copilot has no associated projects.
 * 
 * Parameters:
 * copilotProfileId - the ID of the copilot profile
 * 
 * Returns:
 * the copilot projects for the specified copilot (not null, doesn't contain null)
 * 
 * Throws:
 * IllegalArgumentException if copilotProfileId <= 0
 * CopilotDAOException if some other error occurred
 * @throws IllegalArgumentException if copilotProfileId <= 0
 * @throws CopilotDAOException if some other error occurred
 * @param copilotProfileId the ID of the copilot profile
 * @return the copilot projects for the specified copilot (not null, doesn't contain null)
*/
public List<CopilotProject> getCopilotProjects(long copilotProfileId)throws CopilotDAOException;
}

