package com.topcoder.direct.services.copilot.dao;

import com.topcoder.direct.services.copilot.model.CopilotProfile;

/**
 * This interface represents a copilot profile DAO. It extends GenericDAO<CopilotProfile> and provides an additional method for retrieving copilot profile by the given copilot user ID.
 * 
 * Thread Safety:
 * Implementations of this interface must be thread safe when entities passed to them are used by the caller in thread safe manner.
*/
public interface CopilotProfileDAO extends GenericDAO<CopilotProfile> {
/**
 * Retrieves the copilot profile of the user with the given ID.
 * 
 * Parameters:
 * userId - the user ID of the copilot
 * 
 * Returns:
 * the retrieved copilot profile or null if copilot user with the given ID doesn't exist
 * 
 * Throws:
 * IllegalArgumentException if userId <= 0
 * CopilotDAOException if some other error occurred
 * @throws IllegalArgumentException if userId <= 0
 * @throws CopilotDAOException if some other error occurred
 * @param userId the user ID of the copilot
 * @return the retrieved copilot profile or null if copilot user with the given ID doesn't exist
*/
public CopilotProfile getCopilotProfile(long userId)throws CopilotDAOException;
}

