package com.topcoder.direct.services.copilot.dao;


import com.topcoder.util.errorhandling.BaseRuntimeException;
import com.topcoder.util.errorhandling.ExceptionData;

/**
 * This exception is thrown by BaseDAO when the class was not initialized properly (e.g. while required properly is not specified or property value has invalid format).
 * 
 * Thread Safety:
 * This class is not thread safe because its base class is not thread safe.
 */
public class CopilotDAOInitializationException extends BaseRuntimeException {
    /**
     * Creates a new instance of this exception with the given message.
     * 
     * Parameter:
     * message - the detailed error message of this exception
     * @param message the detailed error message of this exception
     */
    public CopilotDAOInitializationException(String message) {
        super(message);
    }

    /**
     * Creates a new instance of this exception with the given message and cause.
     * 
     * Parameters:
     * message - the detailed error message of this exception
     * cause - the inner cause of this exception
     * @param message the detailed error message of this exception
     * @param cause the inner cause of this exception
     */
    public CopilotDAOInitializationException(String message, Throwable cause) {
        super(message,cause);
    }

    /**
     * Creates a new instance of this exception with the given message and exception data.
     * 
     * Parameters:
     * message - the detailed error message of this exception
     * data - the exception data
     * @param message the detailed error message of this exception
     * @param data the exception data
     */
    public CopilotDAOInitializationException(String message, ExceptionData data) {
        super(message,data);
    }

    /**
     * Creates a new instance of this exception with the given message, cause and exception data.
     * 
     * Parameters:
     * message - the detailed error message of this exception
     * cause - the inner cause of this exception
     * data - the exception data
     * @param message the detailed error message of this exception
     * @param cause the inner cause of this exception
     * @param data the exception data
     */
    public CopilotDAOInitializationException(String message, Throwable cause, ExceptionData data) {
        super(message,cause,data);
    }
}

