package com.topcoder.direct.services.copilot.dao;

import com.topcoder.util.errorhandling.BaseCriticalException;
import com.topcoder.util.errorhandling.ExceptionData;


/**
 * This exception is thrown by BaseDAO, implementations of LookupDAO, UtilityDAO and GenericDAO when some unexpected error occurred. Also this exception is used as a base class for other specific custom exceptions.
 * 
 * Thread Safety:
 * This class is not thread safe because its base class is not thread safe.
 */
public class CopilotDAOException extends BaseCriticalException {
    /**
     * Creates a new instance of this exception with the given message.
     * 
     * Parameters:
     * message - the detailed error message of this exception
     * @param message the detailed error message of this exception
     */
    public CopilotDAOException(String message) {
        super(message);
    }

    /**
     * Creates a new instance of this exception with the given message and cause.
     * 
     * Parameters:
     * message - the detailed error message of this exception
     * cause - the inner cause of this exception
     * @param message the detailed error message of this exception
     * @param cause the inner cause of this exception
     */
    public CopilotDAOException(String message, Throwable cause) {
        super(message,cause);
    }

    /**
     * Creates a new instance of this exception with the given message and exception data.
     * 
     * Parameters:
     * message - the detailed error message of this exception
     * data - the exception data
     * @param message the detailed error message of this exception
     * @param data the exception data
     */
    public CopilotDAOException(String message, ExceptionData data) {
        super(message,data);
    }

    /**
     * Creates a new instance of this exception with the given message, cause and exception data.
     * 
     * Parameters:
     * message - the detailed error message of this exception
     * cause - the inner cause of this exception
     * data - the exception data
     * @param message the detailed error message of this exception
     * @param cause the inner cause of this exception
     * @param data the exception data
     */
    public CopilotDAOException(String message, Throwable cause, ExceptionData data) {
        super(message,cause,data);
    }
}

