/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.ldap;

import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.LikeFilter;

public class LikeFragmentBuilder
implements SearchFragmentBuilder {
    private static final String STAR_CHAR = "\\2a";
    private static final String LEFR_BRACKET = "\\28";
    private static final String RIGHT_BRACKET = "\\29";
    private static final String SLASH = "\\5c";
    private static final int PREFIX_LENGTH = 3;

    public void buildSearch(Filter filter, SearchContext searchContext) throws UnrecognizedFilterException {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        if (searchContext == null) {
            throw new IllegalArgumentException("The searchContext should not be null.");
        }
        if (!(filter instanceof LikeFilter)) {
            throw new UnrecognizedFilterException("The filter should be an LikeFilter, but a type of " + filter.getClass().getName() + ".", filter);
        }
        LikeFilter likeFilter = (LikeFilter)filter;
        StringBuffer buffer = searchContext.getSearchString();
        buffer.append("(").append(SearchBuilderHelper.getRealName(likeFilter.getName(), searchContext)).append("=");
        buffer.append(this.buildFromLikeFilter(likeFilter)).append(")");
    }

    protected String buildFromLikeFilter(LikeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        StringBuffer buffer = new StringBuffer();
        String value = filter.getValue();
        if (value.startsWith("SS:") || value.startsWith("EW:")) {
            buffer.append("*");
        }
        buffer.append(this.escapeWildcard(value.substring(3), value.startsWith("WC:"), filter.getEscapeCharacter()));
        if (value.charAt(0) == 'S') {
            buffer.append("*");
        }
        return buffer.toString();
    }

    private String escapeWildcard(String content, boolean isStartWithWC, char escapeChar) {
        StringBuffer buffer = new StringBuffer();
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c == escapeChar && isStartWithWC && i < length - 1 && content.charAt(i + 1) == '*') {
                buffer.append(STAR_CHAR);
                ++i;
                continue;
            }
            if (c == '(') {
                buffer.append(LEFR_BRACKET);
                continue;
            }
            if (c == ')') {
                buffer.append(RIGHT_BRACKET);
                continue;
            }
            if (c == '*' && !isStartWithWC) {
                buffer.append(STAR_CHAR);
                continue;
            }
            if (c == '\\') {
                buffer.append(SLASH);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

