/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.ldap;

import com.topcoder.search.builder.SearchStringBuilder;
import com.topcoder.search.builder.filter.AndFilter;
import com.topcoder.search.builder.filter.BetweenFilter;
import com.topcoder.search.builder.filter.EqualToFilter;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.GreaterThanFilter;
import com.topcoder.search.builder.filter.GreaterThanOrEqualToFilter;
import com.topcoder.search.builder.filter.InFilter;
import com.topcoder.search.builder.filter.LessThanFilter;
import com.topcoder.search.builder.filter.LessThanOrEqualToFilter;
import com.topcoder.search.builder.filter.LikeFilter;
import com.topcoder.search.builder.filter.NotFilter;
import com.topcoder.search.builder.filter.OrFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LDAPSearchStringBuilder
implements SearchStringBuilder {
    private static final String STAR_CHAR = "\\2a";
    private static final String LEFR_BRACKET = "\\28";
    private static final String RIGHT_BRACKET = "\\29";
    private static final String SLASH = "\\5c";
    private static final int PREFIX_LENGTH = 3;
    private final Map aliasMap;

    public LDAPSearchStringBuilder(Map aliasMap) {
        if (aliasMap == null) {
            throw new NullPointerException("The aliasMap should not be null to contruct LDAPSearchStringBuilder.");
        }
        this.aliasMap = new HashMap(aliasMap);
    }

    public String buildSearchString(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildSearchString in LDAPSearchStringBuilder.");
        }
        return this.buildRecursively(filter);
    }

    protected String buildFromAndFilter(AndFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromAndFilter in LDAPSearchStringBuilder.");
        }
        List list = filter.getFilters();
        ArrayList<String> result = new ArrayList<String>();
        Iterator filterIt = list.iterator();
        while (filterIt.hasNext()) {
            result.add(this.buildSearchString((Filter)filterIt.next()));
        }
        Iterator resultIt = result.iterator();
        StringBuffer buffer = new StringBuffer((String)resultIt.next());
        while (resultIt.hasNext()) {
            buffer = new StringBuffer("(&" + buffer.toString());
            buffer.append(" ");
            buffer.append((String)resultIt.next());
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String buildFromOrFilter(OrFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromOrFilter in LDAPSearchStringBuilder.");
        }
        List list = filter.getFilters();
        ArrayList<String> result = new ArrayList<String>();
        Iterator filterIt = list.iterator();
        while (filterIt.hasNext()) {
            result.add(this.buildSearchString((Filter)filterIt.next()));
        }
        Iterator resultIt = result.iterator();
        StringBuffer buffer = new StringBuffer((String)resultIt.next());
        while (resultIt.hasNext()) {
            buffer = new StringBuffer("(|" + buffer.toString());
            buffer.append(" ");
            buffer.append((String)resultIt.next());
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String buildFromNotFilter(NotFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromNotFilter in LDAPSearchStringBuilder.");
        }
        StringBuffer buffer = new StringBuffer("(!");
        buffer.append(this.buildSearchString(filter.getFilter()));
        buffer.append(")");
        return buffer.toString();
    }

    protected String buildFromInFilter(InFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromInFilter in LDAPSearchStringBuilder.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        List list = filter.getList();
        StringBuffer buffer = new StringBuffer("(");
        buffer.append(name);
        buffer.append("=");
        buffer.append(list.get(0).toString());
        buffer.append(")");
        for (int j = 1; j < list.size(); ++j) {
            buffer = new StringBuffer("(|" + buffer.toString());
            buffer.append(" (");
            buffer.append(name);
            buffer.append("=");
            buffer.append(list.get(j).toString());
            buffer.append("))");
        }
        return buffer.toString();
    }

    protected String buildFromBetweenFilter(BetweenFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromBetweenFilter in LDAPSearchStringBuilder.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        Comparable lowThreshold = filter.getLowerThreshold();
        Comparable upperThreshold = filter.getUpperThreshold();
        StringBuffer buffer = new StringBuffer("(&(");
        buffer.append(name);
        buffer.append(">=");
        buffer.append(lowThreshold.toString());
        buffer.append(")(");
        buffer.append(name);
        buffer.append("<=");
        buffer.append(upperThreshold.toString());
        buffer.append("))");
        return buffer.toString();
    }

    protected String buildFromEqualToFilter(EqualToFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromEqualToFilter in LDAPSearchStringBuilder.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        Comparable value = filter.getValue();
        StringBuffer buffer = new StringBuffer("(");
        buffer.append(name);
        buffer.append(" = ");
        buffer.append(value.toString());
        buffer.append(")");
        return buffer.toString();
    }

    protected String buildFromLessThanFilter(LessThanFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromLessThanFilter in LDAPSearchStringBuilder.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        Comparable value = filter.getValue();
        StringBuffer buffer = new StringBuffer("(&(");
        buffer.append(name);
        buffer.append("<=");
        buffer.append(value.toString());
        buffer.append(") (!(");
        buffer.append(name);
        buffer.append("=");
        buffer.append(value.toString());
        buffer.append(")))");
        return buffer.toString();
    }

    protected String buildFromLessThanOrEqualToFilter(LessThanOrEqualToFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromLessThanOrEqualToFilter in LDAPSearchStringBuilder.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        Comparable value = filter.getValue();
        StringBuffer buffer = new StringBuffer("(");
        buffer.append(name);
        buffer.append("<=");
        buffer.append(value.toString());
        buffer.append(")");
        return buffer.toString();
    }

    protected String buildFromGreaterThanFilter(GreaterThanFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromGreaterThanFilter in LDAPSearchStringBuilder.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        Comparable value = filter.getValue();
        StringBuffer buffer = new StringBuffer("(&(");
        buffer.append(name);
        buffer.append(">=");
        buffer.append(value.toString());
        buffer.append(") (!(");
        buffer.append(name);
        buffer.append("=");
        buffer.append(value.toString());
        buffer.append(")))");
        return buffer.toString();
    }

    protected String buildFromGreaterThanOrEqualToFilter(GreaterThanOrEqualToFilter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildFromGreaterThanOrEqualToFilter.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        Comparable value = filter.getValue();
        StringBuffer buffer = new StringBuffer("(");
        buffer.append(name);
        buffer.append(">=");
        buffer.append(value.toString());
        buffer.append(")");
        return buffer.toString();
    }

    protected String buildFromLikeFilter(LikeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        StringBuffer buffer = new StringBuffer();
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        buffer.append("(").append(name).append("=");
        String value = filter.getValue();
        if (value.startsWith("SS:") || value.startsWith("EW:")) {
            buffer.append("*");
        }
        buffer.append(this.escapeWildcard(value.substring(3), value.startsWith("WC:"), filter.getEscapeCharacter()));
        if (value.charAt(0) == 'S') {
            buffer.append("*");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String escapeWildcard(String content, boolean isStartWithWC, char escapeChar) {
        StringBuffer buffer = new StringBuffer();
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c == escapeChar && isStartWithWC && i < length - 1 && content.charAt(i + 1) == '*') {
                buffer.append(STAR_CHAR);
                ++i;
                continue;
            }
            if (c == '(') {
                buffer.append(LEFR_BRACKET);
                continue;
            }
            if (c == ')') {
                buffer.append(RIGHT_BRACKET);
                continue;
            }
            if (c == '*' && !isStartWithWC) {
                buffer.append(STAR_CHAR);
                continue;
            }
            if (c == '\\') {
                buffer.append(SLASH);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected String buildRecursively(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("the filter should not be null to buildRecursively in LDAPSearchStringBuilder.");
        }
        int type = filter.getFilterType();
        if (type == 7) {
            return this.buildFromAndFilter((AndFilter)filter);
        }
        if (type == 8) {
            return this.buildFromOrFilter((OrFilter)filter);
        }
        if (type == 9) {
            return this.buildFromNotFilter((NotFilter)filter);
        }
        if (type == 6) {
            return this.buildFromInFilter((InFilter)filter);
        }
        if (type == 5) {
            return this.buildFromBetweenFilter((BetweenFilter)filter);
        }
        if (type == 4) {
            return this.buildFromEqualToFilter((EqualToFilter)filter);
        }
        if (type == 0) {
            return this.buildFromLessThanFilter((LessThanFilter)filter);
        }
        if (type == 1) {
            return this.buildFromLessThanOrEqualToFilter((LessThanOrEqualToFilter)filter);
        }
        if (type == 2) {
            return this.buildFromGreaterThanFilter((GreaterThanFilter)filter);
        }
        if (type == 3) {
            return this.buildFromGreaterThanOrEqualToFilter((GreaterThanOrEqualToFilter)filter);
        }
        if (type == 10) {
            return this.buildFromLikeFilter((LikeFilter)filter);
        }
        return null;
    }
}

