/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.ldap;

import com.topcoder.search.builder.PersistenceOperationException;
import com.topcoder.search.builder.SearchBuilderConfigurationException;
import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.SearchStrategy;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.ldap.LDAPConnectionInformation;
import com.topcoder.util.classassociations.ClassAssociator;
import com.topcoder.util.classassociations.IllegalHandlerException;
import com.topcoder.util.net.ldap.sdkinterface.LDAPSDK;
import com.topcoder.util.net.ldap.sdkinterface.LDAPSDKConnection;
import com.topcoder.util.net.ldap.sdkinterface.LDAPSDKException;
import com.topcoder.util.objectfactory.InvalidClassSpecificationException;
import com.topcoder.util.objectfactory.ObjectFactory;
import com.topcoder.util.objectfactory.SpecificationFactory;
import com.topcoder.util.objectfactory.impl.ConfigManagerSpecificationFactory;
import com.topcoder.util.objectfactory.impl.IllegalReferenceException;
import com.topcoder.util.objectfactory.impl.SpecificationConfigurationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LDAPSearchStrategy
implements SearchStrategy {
    private final LDAPConnectionInformation connectionInfo;
    private final ClassAssociator searchFragmentBuilders;
    static /* synthetic */ Class class$com$topcoder$search$builder$filter$Filter;
    static /* synthetic */ Class class$com$topcoder$search$builder$ldap$LDAPConnectionInformation;
    static /* synthetic */ Class class$java$lang$String;

    public LDAPSearchStrategy(LDAPConnectionInformation connectionInfo, Map associations) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("The LDAPConnectionInformation should not be null.");
        }
        if (associations == null) {
            throw new IllegalArgumentException("The associations should not be null.");
        }
        this.connectionInfo = connectionInfo;
        this.searchFragmentBuilders = new ClassAssociator();
        Iterator it = associations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof Class) || !(class$com$topcoder$search$builder$filter$Filter == null ? LDAPSearchStrategy.class$("com.topcoder.search.builder.filter.Filter") : class$com$topcoder$search$builder$filter$Filter).isAssignableFrom((Class)key)) {
                throw new IllegalArgumentException("Invalid key exists in associations.");
            }
            if (!(value instanceof SearchFragmentBuilder)) {
                throw new IllegalArgumentException("Invalid value exists in associations.");
            }
            try {
                this.searchFragmentBuilders.addClassAssociation((Class)key, value);
            }
            catch (IllegalHandlerException e) {
                throw new IllegalArgumentException("invalid Handler exists in associations.");
            }
        }
    }

    public LDAPSearchStrategy(String namespace) throws SearchBuilderConfigurationException {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace should not be null.");
        }
        if (namespace.trim().length() == 0) {
            throw new IllegalArgumentException("The namespace should not be empty.");
        }
        this.searchFragmentBuilders = SearchBuilderHelper.loadClassAssociator(namespace);
        try {
            String identifier;
            String objectFactoryNS = SearchBuilderHelper.getConfigProperty(namespace, "connectionInfoFactoryNamespace", true);
            ConfigManagerSpecificationFactory specificationFactory = new ConfigManagerSpecificationFactory(objectFactoryNS);
            ObjectFactory objectFactory = new ObjectFactory((SpecificationFactory)specificationFactory);
            String key = SearchBuilderHelper.getConfigProperty(namespace, "connectionInfo.classname", false);
            if (key == null || key.trim().length() == 0) {
                key = (class$com$topcoder$search$builder$ldap$LDAPConnectionInformation == null ? (class$com$topcoder$search$builder$ldap$LDAPConnectionInformation = LDAPSearchStrategy.class$("com.topcoder.search.builder.ldap.LDAPConnectionInformation")) : class$com$topcoder$search$builder$ldap$LDAPConnectionInformation).getName();
            }
            this.connectionInfo = (identifier = SearchBuilderHelper.getConfigProperty(namespace, "connectionInfo.identifier", false)) == null || identifier.trim().length() == 0 ? (LDAPConnectionInformation)objectFactory.createObject(key) : (LDAPConnectionInformation)objectFactory.createObject(key, identifier);
        }
        catch (SpecificationConfigurationException e) {
            throw new SearchBuilderConfigurationException("SpecificationConfigurationException occurs.", e);
        }
        catch (IllegalReferenceException e) {
            throw new SearchBuilderConfigurationException("IllegalReferenceException occurs.", e);
        }
        catch (InvalidClassSpecificationException e) {
            throw new SearchBuilderConfigurationException("InvalidClassSpecificationException occurs.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object search(String context, Filter filter, List returnFields, Map aliasMap) throws PersistenceOperationException, UnrecognizedFilterException {
        Iterator iterator;
        if (context == null) {
            throw new IllegalArgumentException("The context should not be null.");
        }
        if (context.trim().length() == 0) {
            throw new IllegalArgumentException("The context should not be empty.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("The context should not be null.");
        }
        SearchBuilderHelper.checkList(returnFields, "returnFields", class$java$lang$String == null ? (class$java$lang$String = LDAPSearchStrategy.class$("java.lang.String")) : class$java$lang$String);
        SearchBuilderHelper.checkaliasMap(aliasMap, "aliasMap");
        LDAPSDKConnection connection = null;
        try {
            try {
                connection = this.connect();
                String[] array = returnFields.toArray(new String[0]);
                SearchContext searchContext = this.buildSearchContext(context, filter, returnFields, aliasMap);
                Iterator it = connection.search(context, this.connectionInfo.getScope(), searchContext.getSearchString().toString(), array);
                ArrayList list = new ArrayList();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                iterator = list.iterator();
                Object var12_12 = null;
                if (connection == null) return iterator;
            }
            catch (LDAPSDKException e) {
                throw new PersistenceOperationException("Search the  ldap failed.", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (connection == null) throw throwable;
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (LDAPSDKException e2) {
                throw new PersistenceOperationException("can not disconnect the ldap connection.", e2);
            }
        }
        try {}
        catch (LDAPSDKException e2) {
            throw new PersistenceOperationException("can not disconnect the ldap connection.", e2);
        }
        connection.disconnect();
        return iterator;
    }

    protected SearchContext buildSearchContext(String context, Filter filter, List returnFields, Map aliasMap) throws UnrecognizedFilterException {
        SearchContext searchContext = new SearchContext(this.searchFragmentBuilders, aliasMap);
        SearchFragmentBuilder builder = searchContext.getFragmentBuilder(filter);
        if (builder == null) {
            throw new UnrecognizedFilterException("No SearchFragmentBuilder can be retrieved.", filter);
        }
        builder.buildSearch(filter, searchContext);
        return searchContext;
    }

    protected LDAPSDKConnection connect() throws PersistenceOperationException {
        LDAPSDKConnection connection = null;
        try {
            LDAPSDK factory = this.connectionInfo.getFactory();
            connection = this.connectionInfo.isSecure() ? factory.createSSLConnection() : factory.createConnection();
            connection.connect(this.connectionInfo.getHost(), this.connectionInfo.getPort());
            String dnroot = this.connectionInfo.getDnroot();
            String password = this.connectionInfo.getPassword();
            if (dnroot != null && dnroot.length() > 0 && password != null && password.length() > 0) {
                connection.authenticate(3, this.connectionInfo.getDnroot(), this.connectionInfo.getPassword());
            } else {
                connection.authenticateAnonymous(3);
            }
            return connection;
        }
        catch (LDAPSDKException e) {
            throw new PersistenceOperationException("LDAPSDKException occurs whilt connect.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

