/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.ldap;

import com.topcoder.search.builder.ConnectionInformation;
import com.topcoder.search.builder.ConnectionStrategy;
import com.topcoder.search.builder.PersistenceOperationException;
import com.topcoder.search.builder.ldap.LDAPConnectionInformation;
import com.topcoder.util.net.ldap.sdkinterface.LDAPSDK;
import com.topcoder.util.net.ldap.sdkinterface.LDAPSDKConnection;
import com.topcoder.util.net.ldap.sdkinterface.LDAPSDKException;
import java.util.Iterator;
import java.util.List;

public class LDAPConnectionStrategy
extends ConnectionStrategy {
    private LDAPSDKConnection connection = null;
    private final String context;

    public LDAPConnectionStrategy(ConnectionInformation connectionInfo, String context) {
        super(connectionInfo);
        if (context == null) {
            throw new NullPointerException("The context should not be null to construct the LDAPConnectionStrategy.");
        }
        if (context.length() == 0) {
            throw new IllegalArgumentException("The context should not be empty to construct the LDAPConnectionStrategy.");
        }
        this.connection = null;
        this.context = context;
    }

    public synchronized Object search(String searchString, List fields) throws PersistenceOperationException {
        if (searchString == null) {
            throw new NullPointerException("The searchString should not be null to search.");
        }
        if (searchString.length() == 0 || fields.size() == 0) {
            throw new IllegalArgumentException("The param should not be empty to search in LDAPConnectionStrategy.");
        }
        if (fields == null) {
            throw new NullPointerException("The fields should not be null to search in LDAPConnectionStrategy.");
        }
        Iterator it = fields.iterator();
        String[] array = new String[fields.size()];
        int index = 0;
        while (it.hasNext()) {
            Object nextItem = it.next();
            if (nextItem == null || !(nextItem instanceof String)) {
                throw new IllegalArgumentException("The field should be instance of String to search in LDAPConnectionStrategy.");
            }
            String filed = (String)nextItem;
            if (filed.length() == 0) {
                throw new IllegalArgumentException("The field should not be null to search.");
            }
            array[index++] = filed;
        }
        try {
            if (this.connection == null) {
                this.connect();
            }
            return this.connection.search(this.context, ((LDAPConnectionInformation)((Object)this.connectionInfo)).getScope(), searchString, array);
        }
        catch (LDAPSDKException e) {
            throw new PersistenceOperationException("LDAPSDKException occurs while do search.", e);
        }
    }

    public synchronized void close() throws PersistenceOperationException {
        try {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (LDAPSDKException e) {
            throw new PersistenceOperationException("LDAPSDKException occues while close in LDAPConnectionStrategy.", e);
        }
    }

    protected synchronized Object searchDataStore(String searchString) throws PersistenceOperationException {
        if (searchString == null) {
            throw new NullPointerException("The searchString should not be null to searchDataStore in LDAPConnectionStrategy.");
        }
        if (searchString.length() == 0) {
            throw new IllegalArgumentException("The searchString should not be empty to searchDataStore in LDAPConnectionStrategy.");
        }
        try {
            return this.connection.search(this.context, ((LDAPConnectionInformation)((Object)this.connectionInfo)).getScope(), searchString);
        }
        catch (LDAPSDKException e) {
            throw new PersistenceOperationException("LDAPSDKException occurs while do searchDataStore.", e);
        }
    }

    protected synchronized void connect() throws PersistenceOperationException {
        if (this.connection != null) {
            return;
        }
        try {
            LDAPConnectionInformation ldapInformation = (LDAPConnectionInformation)((Object)this.connectionInfo);
            LDAPSDK factory = ldapInformation.getFactory();
            this.connection = ldapInformation.isSecure() ? factory.createSSLConnection() : factory.createConnection();
            this.connection.connect(ldapInformation.getHost(), ldapInformation.getPort());
            String dnroot = ldapInformation.getDnroot();
            String password = ldapInformation.getPassword();
            if (dnroot != null && dnroot.length() > 0 && password != null && password.length() > 0) {
                this.connection.authenticate(3, ldapInformation.getDnroot(), ldapInformation.getPassword());
            } else {
                this.connection.authenticateAnonymous(3);
            }
        }
        catch (LDAPSDKException e) {
            throw new PersistenceOperationException("LDAPSDKException occurs whilt connect.", e);
        }
    }
}

