/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.ldap;

import com.topcoder.util.net.ldap.sdkinterface.LDAPSDK;
import java.util.Properties;

public class LDAPConnectionInformation {
    private final LDAPSDK factory;
    private final String host;
    private final int port;
    private final boolean isSSL;
    private final int scope;
    private final String dnroot;
    private final String password;

    public LDAPConnectionInformation(LDAPSDK factory, String host, int port, boolean isSecure, int scope, String dnroot, String password) {
        if (factory == null) {
            throw new IllegalArgumentException("The factory should not be null.");
        }
        if (host == null) {
            throw new IllegalArgumentException("The host should not be null.");
        }
        if (dnroot == null) {
            throw new IllegalArgumentException("The dnroot should not be null.");
        }
        if (password == null) {
            throw new IllegalArgumentException("The password should not be null.");
        }
        if (host.trim().length() == 0) {
            throw new IllegalArgumentException("The String param should not be rmpty to construct the LDAPConnectionInformation.");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("The port should be > 0.");
        }
        this.factory = factory;
        this.host = host;
        this.port = port;
        this.isSSL = isSecure;
        this.scope = scope;
        this.dnroot = dnroot;
        this.password = password;
    }

    public LDAPConnectionInformation(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("The Property should not be null to construct the LDAPConnectionInformation.");
        }
        this.factory = (LDAPSDK)properties.get("factory");
        if (this.factory == null) {
            throw new IllegalArgumentException("The factory in the Properties is illagal.");
        }
        this.host = properties.getProperty("host");
        this.dnroot = properties.getProperty("dnroot");
        this.password = properties.getProperty("password");
        if (this.host == null) {
            throw new IllegalArgumentException("The host should not be null.");
        }
        if (this.host.length() == 0) {
            throw new IllegalArgumentException("The String host in the Properties is illagal.");
        }
        try {
            this.port = Integer.parseInt(properties.getProperty("port"));
            this.isSSL = Boolean.getBoolean(properties.getProperty("isSSL"));
            this.scope = Integer.parseInt(properties.getProperty("scope"));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The integer value in the properties is illegal.");
        }
    }

    public LDAPSDK getFactory() {
        return this.factory;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.isSSL;
    }

    public int getScope() {
        return this.scope;
    }

    public String getDnroot() {
        return this.dnroot;
    }

    public String getPassword() {
        return this.password;
    }
}

