/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.ldap;

import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.InFilter;
import java.util.Iterator;
import java.util.List;

public class InFragmentBuilder
implements SearchFragmentBuilder {
    public void buildSearch(Filter filter, SearchContext searchContext) throws UnrecognizedFilterException {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        if (searchContext == null) {
            throw new IllegalArgumentException("The searchContext should not be null.");
        }
        if (!(filter instanceof InFilter)) {
            throw new UnrecognizedFilterException("The filter should be an InFilter, but a type of " + filter.getClass().getName() + ".", filter);
        }
        InFilter inFilter = (InFilter)filter;
        List values = inFilter.getList();
        String name = SearchBuilderHelper.getRealName(inFilter.getName(), searchContext);
        StringBuffer buffer = searchContext.getSearchString();
        int initLength = buffer.toString().length();
        Iterator it = values.iterator();
        buffer.append("(").append(name).append("=").append(String.valueOf(it.next())).append(")");
        while (it.hasNext()) {
            buffer.insert(initLength, "(|");
            buffer.append("(").append(name).append("=").append(String.valueOf(it.next())).append(")");
            buffer.append(")");
        }
    }
}

