/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.hibernate;

import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.LikeFilter;

public class LikeFragmentBuilder
implements SearchFragmentBuilder {
    private static final int PREFIX_LENGTH = 3;

    public void buildSearch(Filter filter, SearchContext searchContext) throws UnrecognizedFilterException {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        if (searchContext == null) {
            throw new IllegalArgumentException("The searchContext should not be null.");
        }
        if (!(filter instanceof LikeFilter)) {
            throw new UnrecognizedFilterException("The filter should be a LikeFilter, but a type of " + filter.getClass().getName() + ".", filter);
        }
        LikeFilter likeFilter = (LikeFilter)filter;
        StringBuffer buffer = searchContext.getSearchString();
        buffer.append(SearchBuilderHelper.getRealName(likeFilter.getName(), searchContext));
        buffer.append(" LIKE ?");
        searchContext.getBindableParameters().add(this.buildFromLikeFilter(likeFilter));
        buffer.append(" ESCAPE ?");
        searchContext.getBindableParameters().add(likeFilter.getEscapeCharacter() + "");
    }

    private String buildFromLikeFilter(LikeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The LikeFilter is null.");
        }
        StringBuffer buffer = new StringBuffer();
        String value = filter.getValue();
        String content = value.substring(3);
        if (!value.startsWith("WC:")) {
            content = this.transformString(content, filter.getEscapeCharacter());
        }
        if (value.startsWith("SS:") || value.startsWith("EW:")) {
            buffer.append('%');
        }
        buffer.append(content);
        if (value.charAt(0) == 'S') {
            buffer.append('%');
        }
        return buffer.toString();
    }

    private String transformString(String content, char escapeChar) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '%' || c == '_' || c == escapeChar) {
                buffer.append(escapeChar);
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

