/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.hibernate;

import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.InFilter;
import java.util.Iterator;
import java.util.List;

public class InFragmentBuilder
implements SearchFragmentBuilder {
    public void buildSearch(Filter filter, SearchContext searchContext) throws UnrecognizedFilterException {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        if (searchContext == null) {
            throw new IllegalArgumentException("The searchContext should not be null.");
        }
        if (!(filter instanceof InFilter)) {
            throw new UnrecognizedFilterException("The filter should be an InFilter, but a type of " + filter.getClass().getName() + ".", filter);
        }
        InFilter inFilter = (InFilter)filter;
        StringBuffer buffer = searchContext.getSearchString();
        List params = searchContext.getBindableParameters();
        buffer.append(SearchBuilderHelper.getRealName(inFilter.getName(), searchContext));
        buffer.append(" IN (");
        List values = inFilter.getList();
        boolean isFirst = true;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            params.add(it.next());
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            buffer.append("?");
        }
        buffer.append(")");
    }
}

