/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.hibernate;

import com.topcoder.search.builder.PersistenceOperationException;
import com.topcoder.search.builder.SearchBuilderConfigurationException;
import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.SearchStrategy;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.hibernate.HibernateHelper;
import com.topcoder.util.classassociations.ClassAssociator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class HibernateSearchStrategy
implements SearchStrategy {
    private static final String HIBERNATE_CONFIG_FILE_PATH = "hibernateConfigFilePath";
    private static final String COMMA = ",";
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private final SessionFactory sessionFactory;
    private final ClassAssociator fragmentBuilders;
    private boolean isExternalSessionFactory = false;
    static /* synthetic */ Class class$com$topcoder$search$builder$hibernate$HibernateSearchStrategy;
    static /* synthetic */ Class class$java$lang$String;

    public HibernateSearchStrategy() throws SearchBuilderConfigurationException {
        this((class$com$topcoder$search$builder$hibernate$HibernateSearchStrategy == null ? (class$com$topcoder$search$builder$hibernate$HibernateSearchStrategy = HibernateSearchStrategy.class$("com.topcoder.search.builder.hibernate.HibernateSearchStrategy")) : class$com$topcoder$search$builder$hibernate$HibernateSearchStrategy).getName());
    }

    public HibernateSearchStrategy(String namespace) throws SearchBuilderConfigurationException {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace should not be null.");
        }
        if (namespace.trim().length() == 0) {
            throw new IllegalArgumentException("The namespace should not be empty.");
        }
        this.fragmentBuilders = SearchBuilderHelper.loadClassAssociator(namespace);
        String filePath = HibernateHelper.getConfigPropertyValue(namespace, HIBERNATE_CONFIG_FILE_PATH, false);
        try {
            this.sessionFactory = filePath == null ? new Configuration().buildSessionFactory() : new Configuration().configure(filePath).buildSessionFactory();
        }
        catch (HibernateException ex) {
            throw new SearchBuilderConfigurationException("Initial SessionFactory creation failed.", ex);
        }
    }

    public HibernateSearchStrategy(SessionFactory sessionFactory, ClassAssociator fragmentBuilders) {
        if (sessionFactory == null) {
            throw new IllegalArgumentException("The sessionFactory should not be null.");
        }
        if (fragmentBuilders == null) {
            throw new IllegalArgumentException("The fragmentBuilders should not be null.");
        }
        this.sessionFactory = sessionFactory;
        this.fragmentBuilders = fragmentBuilders;
        this.isExternalSessionFactory = true;
    }

    public HibernateSearchStrategy(String sessionFactoryJndiName, ClassAssociator fragmentBuilders) throws SearchBuilderConfigurationException {
        if (sessionFactoryJndiName == null) {
            throw new IllegalArgumentException("The sessionFactoryJndiName should not be null.");
        }
        if (fragmentBuilders == null) {
            throw new IllegalArgumentException("The fragmentBuilders should not be null.");
        }
        SessionFactory sessionFactory = null;
        try {
            InitialContext ctx = new InitialContext();
            sessionFactory = (SessionFactory)ctx.lookup(sessionFactoryJndiName);
            if (sessionFactory == null) {
                throw new SearchBuilderConfigurationException("The sessionFactory under context name " + sessionFactoryJndiName + " should not be null.");
            }
        }
        catch (NamingException e) {
            throw new SearchBuilderConfigurationException("A NamingException occurred.", e);
        }
        catch (ClassCastException e) {
            throw new SearchBuilderConfigurationException("The object under context name " + sessionFactoryJndiName + " is not type of SessionFactory.", e);
        }
        this.sessionFactory = sessionFactory;
        this.fragmentBuilders = fragmentBuilders;
        this.isExternalSessionFactory = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object search(String context, Filter filter, List returnFields, Map aliasMap) throws UnrecognizedFilterException, PersistenceOperationException {
        Session session;
        if (context == null) {
            throw new IllegalArgumentException("The context should not be null.");
        }
        if (context.trim().length() == 0) {
            throw new IllegalArgumentException("The context should not be empty.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("The context should not be null.");
        }
        SearchBuilderHelper.checkList(returnFields, "returnFields", class$java$lang$String == null ? (class$java$lang$String = HibernateSearchStrategy.class$("java.lang.String")) : class$java$lang$String);
        SearchBuilderHelper.checkaliasMap(aliasMap, "aliasMap");
        SearchContext searchContext = this.buildSearchContext(context, filter, returnFields, aliasMap);
        try {
            session = this.sessionFactory.getCurrentSession();
        }
        catch (HibernateException e) {
            throw new PersistenceOperationException("Persistence error occurred: " + e.getMessage(), e);
        }
        Session session2 = session;
        synchronized (session2) {
            try {
                session.beginTransaction();
                Query query = session.createQuery(searchContext.getSearchString().toString());
                for (int i = 0; i < searchContext.getBindableParameters().size(); ++i) {
                    query.setParameter(i, searchContext.getBindableParameters().get(i));
                }
                List ret = query.list();
                session.getTransaction().commit();
                List list = ret;
                return list;
            }
            catch (HibernateException e) {
                HibernateSearchStrategy.rollBack((org.hibernate.Session)session);
                throw new PersistenceOperationException("Persistence error occurred: " + e.getMessage(), e);
            }
            finally {
                HibernateSearchStrategy.closeSession((org.hibernate.Session)session);
            }
        }
    }

    private static void closeSession(org.hibernate.Session session) throws PersistenceOperationException {
        if (session != null && session.isOpen()) {
            try {
                session.close();
            }
            catch (HibernateException e) {
                throw new PersistenceOperationException("Error occurred when closing the session: " + e.getMessage(), e);
            }
            session = null;
        }
    }

    private static void rollBack(org.hibernate.Session session) throws PersistenceOperationException {
        try {
            session.getTransaction().rollback();
        }
        catch (HibernateException e) {
            throw new PersistenceOperationException("Error occurred when closing the session: " + e.getMessage(), e);
        }
    }

    protected SearchContext buildSearchContext(String context, Filter filter, List returnFields, Map aliasMap) throws UnrecognizedFilterException {
        SearchContext searchContext = new SearchContext(this.fragmentBuilders, aliasMap);
        searchContext.getSearchString().append(this.includeReturnFieldsInSearchString(context, returnFields, aliasMap));
        SearchFragmentBuilder builder = searchContext.getFragmentBuilder(filter);
        if (builder == null) {
            throw new UnrecognizedFilterException("No SearchFragmentBuilder can be retrieved.", filter);
        }
        builder.buildSearch(filter, searchContext);
        return searchContext;
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected void finalize() {
        if (this.sessionFactory != null && !this.isExternalSessionFactory) {
            this.sessionFactory.close();
        }
    }

    private String includeReturnFieldsInSearchString(String context, List fields, Map aliasMap) {
        String lowerCase = context.toLowerCase();
        int indexSelect = lowerCase.indexOf(SELECT);
        int indexFrom = lowerCase.indexOf(FROM);
        if (!lowerCase.startsWith(SELECT) && !lowerCase.startsWith(FROM)) {
            throw new IllegalArgumentException("The context should start with \"SELECT\" or \"FROM\".");
        }
        if (lowerCase.startsWith(SELECT) && indexFrom < 0) {
            throw new IllegalArgumentException("If context starts with \"SELECT\" it must also contain a \"FROM\".");
        }
        if (lowerCase.startsWith(FROM)) {
            return context + " ";
        }
        String[] existingFieldsArray = context.substring(indexSelect + SELECT.length(), indexFrom).trim().split(COMMA);
        String newFields = HibernateSearchStrategy.getFields(fields, aliasMap);
        String existingFields = HibernateSearchStrategy.getFields(Arrays.asList(existingFieldsArray), aliasMap);
        if (newFields.length() == 0) {
            newFields = "";
        } else if (existingFields.length() != 0) {
            newFields = COMMA + newFields;
        }
        return "SELECT " + existingFields + newFields + " FROM " + context.substring(indexFrom + FROM.length()).trim() + " ";
    }

    private static String getFields(List fields, Map aliasMap) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            String value = ((String)fields.get(i)).trim();
            if (aliasMap.containsKey(value)) {
                ret.append(aliasMap.get(value));
            } else {
                ret.append(value);
            }
            if (i >= fields.size() - 1) continue;
            ret.append(COMMA);
        }
        return ret.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

