/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.hibernate;

import com.topcoder.search.builder.SearchBuilderConfigurationException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.UnknownNamespaceException;

final class HibernateHelper {
    private HibernateHelper() {
    }

    static String getConfigPropertyValue(String namespace, String propertyName, boolean mandatory) throws SearchBuilderConfigurationException {
        String value;
        try {
            value = ConfigManager.getInstance().getString(namespace, propertyName);
        }
        catch (UnknownNamespaceException e) {
            throw new SearchBuilderConfigurationException("The namespace '" + namespace + "' is missing in configuration.", e);
        }
        if (value == null) {
            if (mandatory) {
                throw new SearchBuilderConfigurationException(propertyName + " is required in configuration.");
            }
        } else if (value.trim().length() == 0) {
            throw new SearchBuilderConfigurationException(propertyName + " should not be empty in configuration.");
        }
        return value;
    }
}

