/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.filter;

import com.topcoder.search.builder.ValidationResult;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.util.datavalidator.ObjectValidator;
import java.util.Iterator;
import java.util.Map;

public class LikeFilter
implements Filter {
    public static final String CONTAIN_TAGS = "SS:";
    public static final String START_WITH_TAG = "SW:";
    public static final String END_WITH_TAG = "EW:";
    public static final String WITH_CONTENT = "WC:";
    private static final char DEFAULTESCAPECHAR = '\\';
    private static final char[] INVALID_ESCAPE = new char[]{'%', '_', '*'};
    private final char escapeCharacter;
    private final String fieldName;
    private final String value;
    static /* synthetic */ Class class$com$topcoder$util$datavalidator$ObjectValidator;
    static /* synthetic */ Class class$java$lang$String;

    public LikeFilter(String name, String value) {
        this(name, value, '\\');
    }

    public LikeFilter(String name, String value, char escapeCharacter) {
        if (name == null) {
            throw new IllegalArgumentException("The name should not be null.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("The name should not be empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value should not be null.");
        }
        if (!(value.startsWith(CONTAIN_TAGS) || value.startsWith(START_WITH_TAG) || value.startsWith(END_WITH_TAG) || value.startsWith(WITH_CONTENT))) {
            throw new IllegalArgumentException("The value should start with 'SS:', 'SW:', 'EW:' or 'WC:'.");
        }
        if (value.length() == CONTAIN_TAGS.length()) {
            throw new IllegalArgumentException("The value without prefix should not be of zero length.");
        }
        for (int i = 0; i < INVALID_ESCAPE.length; ++i) {
            if (INVALID_ESCAPE[i] != escapeCharacter) continue;
            throw new IllegalArgumentException("The escapeCharacter '" + escapeCharacter + "' is invalid.");
        }
        this.fieldName = name;
        this.value = value;
        this.escapeCharacter = escapeCharacter;
    }

    public ValidationResult isValid(Map validators, Map alias) {
        this.checkMap(validators, class$com$topcoder$util$datavalidator$ObjectValidator == null ? (class$com$topcoder$util$datavalidator$ObjectValidator = LikeFilter.class$("com.topcoder.util.datavalidator.ObjectValidator")) : class$com$topcoder$util$datavalidator$ObjectValidator, "validators");
        this.checkMap(alias, class$java$lang$String == null ? (class$java$lang$String = LikeFilter.class$("java.lang.String")) : class$java$lang$String, "alias");
        ObjectValidator rule = (ObjectValidator)validators.get(this.fieldName);
        if (rule == null) {
            rule = (ObjectValidator)validators.get(alias.get(this.fieldName));
        }
        if (rule == null) {
            throw new IllegalArgumentException("No ObjectValidator can be retrieved via the fieldName '" + this.fieldName + "'.");
        }
        String message = rule.getMessage((Object)this.value);
        if (message != null) {
            return ValidationResult.createInvalidResult("Validate failed for " + message + ".", this);
        }
        return ValidationResult.createValidResult();
    }

    private void checkMap(Map map, Class valueClass, String name) {
        if (map == null) {
            throw new IllegalArgumentException("The " + name + " should not be null.");
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("The key of the map " + name + " contains null_String.");
            }
            if (valueClass.isInstance(entry.getValue())) continue;
            throw new IllegalArgumentException("The value of the map " + name + " contains invalid value.");
        }
    }

    public final int getFilterType() {
        return 10;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public String getName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.value;
    }

    public Object clone() {
        return new LikeFilter(this.fieldName, this.value, this.escapeCharacter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

