/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.filter;

import com.topcoder.search.builder.ValidationResult;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.FilterHelper;
import com.topcoder.util.datavalidator.ObjectValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InFilter
implements Filter {
    private final String fieldName;
    private final List values;

    public InFilter(String name, List values) {
        if (name == null) {
            throw new IllegalArgumentException("The param should not be null to construct InFilter.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("The param should not be empty to construct InFilter.");
        }
        FilterHelper.checkList(values, "values");
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof Comparable) continue;
            throw new IllegalArgumentException("The items in the values should be Comparable.");
        }
        this.fieldName = name;
        this.values = new ArrayList(values);
    }

    public ValidationResult isValid(Map validators, Map alias) {
        String aliasName;
        if (validators == null) {
            throw new IllegalArgumentException("The validators should not be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("The alias should not be null.");
        }
        if (validators.size() == 0 || alias.size() == 0) {
            throw new IllegalArgumentException("The map should not be empty.");
        }
        FilterHelper.checkMap(validators, "validators");
        FilterHelper.checkMap(alias, "alias");
        ObjectValidator rule = (ObjectValidator)validators.get(this.fieldName);
        if (rule == null && (aliasName = (String)alias.get(this.fieldName)) != null) {
            rule = (ObjectValidator)validators.get(aliasName);
        }
        if (rule == null) {
            return ValidationResult.createInvalidResult("InFilter filter fails for there is no rule.", this);
        }
        if (this.values == null) {
            return ValidationResult.createValidResult();
        }
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            if (rule.getMessage(it.next()) == null) continue;
            return ValidationResult.createInvalidResult("InFilter validation fails.", this);
        }
        return ValidationResult.createValidResult();
    }

    public final int getFilterType() {
        return 6;
    }

    public String getName() {
        return this.fieldName;
    }

    public List getList() {
        return new ArrayList(this.values);
    }

    public Object clone() {
        return new InFilter(this.fieldName, this.values);
    }
}

