/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.filter;

import com.topcoder.search.builder.ValidationResult;
import com.topcoder.search.builder.filter.AbstractAssociativeFilter;
import com.topcoder.search.builder.filter.AndFilter;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.OrFilter;
import com.topcoder.util.datavalidator.ObjectValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FilterHelper {
    private FilterHelper() {
    }

    static void checkList(List list, String listName) {
        if (list == null) {
            throw new IllegalArgumentException("The list " + listName + " should not be null");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("The list " + listName + " should not be empty");
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            throw new IllegalArgumentException("The items in the list " + listName + " should not be null");
        }
    }

    public static void checkMap(Map map, String mapName) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            if (key == null) {
                throw new IllegalArgumentException("The key in the list " + mapName + " should not be null");
            }
            Object value = entry.getValue();
            if (value != null) continue;
            throw new IllegalArgumentException("The value in the list " + mapName + " should not be null");
        }
    }

    public static ValidationResult isValidSimpleFilter(Map validators, Map alias, String name, Comparable value, Filter filter) {
        String aliasName;
        if (validators == null) {
            throw new IllegalArgumentException("The validators should not be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("The alias should not be null.");
        }
        if (validators.size() == 0) {
            throw new IllegalArgumentException("The validators map should not be empty");
        }
        FilterHelper.checkMap(validators, "validators");
        FilterHelper.checkMap(alias, "alias");
        if (name == null) {
            throw new IllegalArgumentException("The name should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value should not be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        ObjectValidator rule = null;
        if (validators.get(name) != null && validators.get(name) instanceof ObjectValidator) {
            rule = (ObjectValidator)validators.get(name);
        }
        if (rule == null && (aliasName = (String)alias.get(name)) != null && validators.get(aliasName) != null && validators.get(aliasName) instanceof ObjectValidator) {
            rule = (ObjectValidator)validators.get(aliasName);
        }
        if (rule == null) {
            throw new IllegalArgumentException("The map validators is invalid to get the check rule.");
        }
        if (rule.getMessage((Object)value) != null) {
            return ValidationResult.createInvalidResult("Filter check valid fails for " + rule.getMessage((Object)value) + ".", filter);
        }
        return ValidationResult.createValidResult();
    }

    public static ValidationResult isValidAssociativeFilter(Map validators, Map alias, List filters) {
        if (validators == null) {
            throw new IllegalArgumentException("The validators should not be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("The alias should not be null.");
        }
        if (validators.size() == 0) {
            throw new IllegalArgumentException("The validators map should not be empty");
        }
        FilterHelper.checkMap(validators, "validators");
        FilterHelper.checkMap(alias, "alias");
        FilterHelper.checkList(filters, "filters");
        Iterator it = filters.iterator();
        while (it.hasNext()) {
            Filter filter = (Filter)it.next();
            ValidationResult v = filter.isValid(validators, alias);
            if (v.isValid()) continue;
            return v;
        }
        return ValidationResult.createValidResult();
    }

    public static AbstractAssociativeFilter associativeFilterclone(AbstractAssociativeFilter filter) {
        ArrayList<Object> newList = new ArrayList<Object>();
        List filters = filter.getFilters();
        Iterator it = filters.iterator();
        while (it.hasNext()) {
            newList.add(((Filter)it.next()).clone());
        }
        if (filter instanceof AndFilter) {
            return new AndFilter(newList);
        }
        return new OrFilter(newList);
    }
}

