/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.filter;

import com.topcoder.search.builder.ValidationResult;
import com.topcoder.search.builder.filter.AbstractSimpleFilter;
import com.topcoder.search.builder.filter.FilterHelper;
import com.topcoder.util.datavalidator.ObjectValidator;
import java.util.Map;

public class BetweenFilter
extends AbstractSimpleFilter {
    public BetweenFilter(String name, Comparable upper, Comparable lower) {
        super(name, upper, lower);
    }

    public ValidationResult isValid(Map validators, Map alias) {
        String aliasName;
        if (validators == null) {
            throw new IllegalArgumentException("The validators should not be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("The alias should not be null.");
        }
        if (validators.size() == 0) {
            throw new IllegalArgumentException("The validators map should not be empty");
        }
        FilterHelper.checkMap(validators, "validators");
        FilterHelper.checkMap(alias, "alias");
        ObjectValidator rule = null;
        if (validators.get(this.fieldName) != null && validators.get(this.fieldName) instanceof ObjectValidator) {
            rule = (ObjectValidator)validators.get(this.fieldName);
        }
        if (rule == null && (aliasName = (String)alias.get(this.fieldName)) != null && validators.get(aliasName) != null && validators.get(aliasName) instanceof ObjectValidator) {
            rule = (ObjectValidator)validators.get(aliasName);
        }
        if (rule == null) {
            throw new IllegalArgumentException("The map validators is invalid to get the check rule.");
        }
        if (rule.getMessage((Object)this.upperThreshold) != null) {
            return ValidationResult.createInvalidResult("Between filter fails for " + rule.getMessage((Object)this.upperThreshold) + " .", this);
        }
        if (rule.getMessage((Object)this.lowerThreshold) != null) {
            return ValidationResult.createInvalidResult("Between filter fails for " + rule.getMessage((Object)this.upperThreshold) + " .", this);
        }
        return ValidationResult.createValidResult();
    }

    public int getFilterType() {
        return 5;
    }

    public Object clone() {
        return new BetweenFilter(this.fieldName, this.upperThreshold, this.lowerThreshold);
    }
}

