/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.filter;

import com.topcoder.search.builder.filter.Filter;

public abstract class AbstractSimpleFilter
implements Filter {
    protected String fieldName;
    protected Comparable value;
    protected Comparable upperThreshold = null;
    protected Comparable lowerThreshold = null;
    protected boolean isUpperThresholdInclusive = false;
    protected boolean isLowerThresholdInclusive = false;

    protected AbstractSimpleFilter(String name, Comparable value) {
        if (name == null) {
            throw new IllegalArgumentException("The name should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value should not be null to construct AbstractSimpleFilter");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("The name should not empty to construct AbstractSimpleFilter");
        }
        this.fieldName = name;
        this.value = value;
    }

    public AbstractSimpleFilter(String name, Comparable upper, Comparable lower) {
        if (name == null) {
            throw new IllegalArgumentException("The name should not be null.");
        }
        if (upper == null) {
            throw new IllegalArgumentException("The upper should not be null.");
        }
        if (lower == null) {
            throw new IllegalArgumentException("The lower should not be null.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The name should not empty to construct AbstractSimpleFilter");
        }
        this.fieldName = name;
        this.upperThreshold = upper;
        this.lowerThreshold = lower;
        this.isLowerThresholdInclusive = true;
        this.isUpperThresholdInclusive = true;
    }

    public String getName() {
        return this.fieldName;
    }

    public Comparable getValue() {
        return this.value;
    }

    public abstract Object clone();

    public Comparable getUpperThreshold() {
        return this.upperThreshold;
    }

    public Comparable getLowerThreshold() {
        return this.lowerThreshold;
    }

    public boolean isUpperInclusive() {
        return this.isUpperThresholdInclusive;
    }

    public boolean isLowerInclusive() {
        return this.isLowerThresholdInclusive;
    }
}

