/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.database;

import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.AbstractSimpleFilter;
import com.topcoder.search.builder.filter.BetweenFilter;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.GreaterThanFilter;
import com.topcoder.search.builder.filter.GreaterThanOrEqualToFilter;
import com.topcoder.search.builder.filter.LessThanFilter;
import com.topcoder.search.builder.filter.LessThanOrEqualToFilter;

public class RangeFragmentBuilder
implements SearchFragmentBuilder {
    public void buildSearch(Filter filter, SearchContext searchContext) throws UnrecognizedFilterException {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        if (searchContext == null) {
            throw new IllegalArgumentException("The searchContext should not be null.");
        }
        if (filter instanceof BetweenFilter) {
            BetweenFilter betweenFilter = (BetweenFilter)filter;
            SearchBuilderHelper.buildDBSimpleFilter(betweenFilter, ">=", searchContext, betweenFilter.getLowerThreshold());
            searchContext.getSearchString().append(" AND ");
            SearchBuilderHelper.buildDBSimpleFilter(betweenFilter, "<=", searchContext, betweenFilter.getUpperThreshold());
            return;
        }
        String operator = null;
        if (filter instanceof GreaterThanFilter) {
            operator = ">";
        } else if (filter instanceof LessThanFilter) {
            operator = "<";
        } else if (filter instanceof GreaterThanOrEqualToFilter) {
            operator = ">=";
        } else if (filter instanceof LessThanOrEqualToFilter) {
            operator = "<=";
        }
        if (operator == null) {
            throw new UnrecognizedFilterException("The filter should be an Range Filter.", filter);
        }
        AbstractSimpleFilter simpleFilter = (AbstractSimpleFilter)filter;
        SearchBuilderHelper.buildDBSimpleFilter(simpleFilter, operator, searchContext, simpleFilter.getValue());
    }
}

