/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.database;

import com.topcoder.search.builder.SearchStringBuilder;
import com.topcoder.search.builder.filter.AbstractAssociativeFilter;
import com.topcoder.search.builder.filter.AbstractSimpleFilter;
import com.topcoder.search.builder.filter.BetweenFilter;
import com.topcoder.search.builder.filter.EqualToFilter;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.GreaterThanFilter;
import com.topcoder.search.builder.filter.GreaterThanOrEqualToFilter;
import com.topcoder.search.builder.filter.InFilter;
import com.topcoder.search.builder.filter.LessThanFilter;
import com.topcoder.search.builder.filter.LessThanOrEqualToFilter;
import com.topcoder.search.builder.filter.LikeFilter;
import com.topcoder.search.builder.filter.NotFilter;
import com.topcoder.search.builder.filter.OrFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DatabaseSearchStringBuilder
implements SearchStringBuilder {
    private static final String LIKE_KEY_WORK = " LIKE '";
    private static final String ESCAPE_KEY_WORK = "' ESCAPE '";
    private static final int PREFIX_LENGTH = 3;
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final String context;
    private final Map aliasMap;

    public DatabaseSearchStringBuilder(String context, Map aliasMap) {
        if (context == null || aliasMap == null) {
            throw new NullPointerException("the context should not be null to construct DatabaseSearchStringBuilder.");
        }
        if (context.length() == 0) {
            throw new IllegalArgumentException("the context should not be empty to construct DatabaseSearchStringBuilder.");
        }
        this.context = context;
        this.aliasMap = new HashMap(aliasMap);
    }

    public String buildSearchString(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("The filter should not be null to buildSearchString in DatabaseSearchStringBuilder.");
        }
        return this.context + " " + this.buildRecursively(filter);
    }

    protected String buildFromAndFilter(Filter filter) {
        return this.buildAssociativeFilter((AbstractAssociativeFilter)filter, " AND ");
    }

    protected String buildFromOrFilter(OrFilter filter) {
        return this.buildAssociativeFilter(filter, " OR ");
    }

    protected String buildFromNotFilter(NotFilter filter) {
        if (filter == null) {
            throw new NullPointerException("The filter should not be null to buildFromNotFilter in DatabaseSearchStringBuilder.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("NOT (").append(this.buildRecursively(filter.getFilter())).append(")");
        return buffer.toString();
    }

    protected String buildFromInFilter(InFilter filter) {
        if (filter == null) {
            throw new NullPointerException("The filter should not be null to buildFromNotFilter in DatabaseSearchStringBuilder.");
        }
        String name = filter.getName();
        if (this.aliasMap.containsKey(name)) {
            name = (String)this.aliasMap.get(name);
        }
        List values = filter.getList();
        StringBuffer buffer = new StringBuffer();
        if (values.size() == 0) {
            return " IN ()";
        }
        Iterator it = values.iterator();
        buffer.append(name);
        buffer.append(" IN (").append(this.getSQLString((Comparable)it.next()));
        while (it.hasNext()) {
            buffer.append(", ").append(this.getSQLString((Comparable)it.next()));
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected String buildFromBetweenFilter(BetweenFilter filter) {
        return this.buildSimpleFilter(filter);
    }

    protected String buildFromEqualToFilter(EqualToFilter filter) {
        return this.buildSimpleFilter(filter);
    }

    protected String buildFromLessThanFilter(LessThanFilter filter) {
        return this.buildSimpleFilter(filter);
    }

    protected String buildFromLessThanOrEqualToFilter(LessThanOrEqualToFilter filter) {
        return this.buildSimpleFilter(filter);
    }

    protected String buildFromGreaterThanFilter(GreaterThanFilter filter) {
        return this.buildSimpleFilter(filter);
    }

    protected String buildFromGreaterThanOrEqualToFilter(GreaterThanOrEqualToFilter filter) {
        return this.buildSimpleFilter(filter);
    }

    protected String buildFromLikeFilter(LikeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The LikeFilter is null.");
        }
        StringBuffer buffer = new StringBuffer();
        String realName = filter.getName();
        if (this.aliasMap.containsKey(realName)) {
            realName = (String)this.aliasMap.get(realName);
        }
        buffer.append(realName).append(LIKE_KEY_WORK);
        String value = filter.getValue();
        String content = value.substring(3);
        if (!value.startsWith("WC:")) {
            content = this.transformString(content, filter.getEscapeCharacter());
        }
        if (value.startsWith("SS:") || value.startsWith("EW:")) {
            buffer.append('%');
        }
        buffer.append(content);
        if (value.charAt(0) == 'S') {
            buffer.append('%');
        }
        buffer.append(ESCAPE_KEY_WORK);
        buffer.append(filter.getEscapeCharacter()).append("'");
        return buffer.toString();
    }

    private String transformString(String content, char escapeChar) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '%' || c == '_' || c == escapeChar) {
                buffer.append(escapeChar);
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected String buildRecursively(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("The filter should not be null to buildRecursively in DatabaseSearchStringBuilder.");
        }
        int type = filter.getFilterType();
        if (type == 7) {
            return this.buildFromAndFilter(filter);
        }
        if (type == 8) {
            return this.buildFromOrFilter((OrFilter)filter);
        }
        if (type == 9) {
            return this.buildFromNotFilter((NotFilter)filter);
        }
        if (type == 6) {
            return this.buildFromInFilter((InFilter)filter);
        }
        if (type == 5) {
            return this.buildFromBetweenFilter((BetweenFilter)filter);
        }
        if (type == 4) {
            return this.buildFromEqualToFilter((EqualToFilter)filter);
        }
        if (type == 0) {
            return this.buildFromLessThanFilter((LessThanFilter)filter);
        }
        if (type == 1) {
            return this.buildFromLessThanOrEqualToFilter((LessThanOrEqualToFilter)filter);
        }
        if (type == 2) {
            return this.buildFromGreaterThanFilter((GreaterThanFilter)filter);
        }
        if (type == 3) {
            return this.buildFromGreaterThanOrEqualToFilter((GreaterThanOrEqualToFilter)filter);
        }
        if (type == 10) {
            return this.buildFromLikeFilter((LikeFilter)filter);
        }
        return null;
    }

    private String getSQLString(Comparable value) {
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Date) {
            return "'" + DATEFORMAT.format((Date)value) + "'";
        }
        return "'" + value.toString() + "'";
    }

    private String buildAssociativeFilter(AbstractAssociativeFilter filter, String associativeType) {
        if (filter == null) {
            throw new NullPointerException("The AbstractAssociativeFilter should not be null to build.");
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = filter.getFilters().iterator();
        while (iter.hasNext()) {
            buffer.append("(").append(this.buildRecursively((Filter)iter.next())).append(")");
            if (!iter.hasNext()) continue;
            buffer.append(associativeType);
        }
        return buffer.toString();
    }

    private String buildSimpleFilter(AbstractSimpleFilter filter) {
        if (filter == null) {
            throw new NullPointerException("The AbstractSimpleFilter should not be null to build.");
        }
        String fieldName = filter.getName();
        String realName = null;
        StringBuffer buffer = new StringBuffer();
        realName = this.aliasMap.containsKey(fieldName) ? (String)this.aliasMap.get(fieldName) : fieldName;
        if (filter.isLowerInclusive() && filter.isUpperInclusive()) {
            buffer.append(realName).append(">=").append(this.getSQLString(filter.getLowerThreshold()));
            buffer.append(" AND ");
            buffer.append(realName).append("<=").append(this.getSQLString(filter.getUpperThreshold()));
        } else if (filter.getLowerThreshold() == null && filter.getUpperThreshold() == null) {
            buffer.append(realName).append("=").append(this.getSQLString(filter.getValue()));
        } else if (filter.getLowerThreshold() != null) {
            buffer.append(realName).append(">");
            if (filter.isLowerInclusive()) {
                buffer.append("=");
            }
            buffer.append(this.getSQLString(filter.getLowerThreshold()));
        } else {
            buffer.append(realName).append("<");
            if (filter.isUpperInclusive()) {
                buffer.append("=");
            }
            buffer.append(this.getSQLString(filter.getUpperThreshold()));
        }
        return buffer.toString();
    }
}

