/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.database;

import com.topcoder.db.connectionfactory.DBConnectionException;
import com.topcoder.db.connectionfactory.DBConnectionFactory;
import com.topcoder.search.builder.PersistenceOperationException;
import com.topcoder.search.builder.SearchBuilderConfigurationException;
import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.SearchStrategy;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.util.classassociations.ClassAssociator;
import com.topcoder.util.classassociations.IllegalHandlerException;
import com.topcoder.util.sql.databaseabstraction.CustomResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DatabaseSearchStrategy
implements SearchStrategy {
    private static final Class[] CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DatabaseSearchStrategy.class$("java.lang.String")) : class$java$lang$String};
    private final DBConnectionFactory connectionFactory;
    private final ClassAssociator fragmentBuilders;
    private final String connectionName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$topcoder$search$builder$filter$Filter;
    static /* synthetic */ Class class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl;

    public DatabaseSearchStrategy(DBConnectionFactory connFactory, String connName, Map associations) {
        if (connFactory == null) {
            throw new IllegalArgumentException("The connFactory should not be null.");
        }
        if (associations == null) {
            throw new IllegalArgumentException("The associations should not be null.");
        }
        this.connectionFactory = connFactory;
        this.connectionName = connName;
        this.fragmentBuilders = new ClassAssociator();
        Iterator it = associations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof Class) || !(class$com$topcoder$search$builder$filter$Filter == null ? DatabaseSearchStrategy.class$("com.topcoder.search.builder.filter.Filter") : class$com$topcoder$search$builder$filter$Filter).isAssignableFrom((Class)key)) {
                throw new IllegalArgumentException("Invalid key exists in associations.");
            }
            if (!(value instanceof SearchFragmentBuilder)) {
                throw new IllegalArgumentException("Invalid value exists in associations.");
            }
            try {
                this.fragmentBuilders.addClassAssociation((Class)key, value);
            }
            catch (IllegalHandlerException e) {
                throw new IllegalArgumentException("invalid Handler exists in associations.");
            }
        }
    }

    public DatabaseSearchStrategy(String namespace) throws SearchBuilderConfigurationException {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace should not be null.");
        }
        if (namespace.trim().length() == 0) {
            throw new IllegalArgumentException("The namespace should not be empty.");
        }
        String factoryNamespace = SearchBuilderHelper.getConfigProperty(namespace, "connectionFactory.name", true);
        String className = SearchBuilderHelper.getConfigProperty(namespace, "connectionFactory.class", false);
        if (className == null || className.trim().length() == 0) {
            className = (class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl == null ? (class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl = DatabaseSearchStrategy.class$("com.topcoder.db.connectionfactory.DBConnectionFactoryImpl")) : class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl).getName();
        }
        try {
            this.connectionFactory = (DBConnectionFactory)Class.forName(className).getConstructor(CLASSES).newInstance(factoryNamespace);
        }
        catch (Exception e) {
            throw new SearchBuilderConfigurationException("can not construct the connectionFactory successfully.", e);
        }
        this.connectionName = SearchBuilderHelper.getConfigProperty(namespace, "connectionName", false);
        this.fragmentBuilders = SearchBuilderHelper.loadClassAssociator(namespace);
    }

    protected SearchContext buildSearchContext(String context, Filter filter, List returnFields, Map aliasMap) throws UnrecognizedFilterException {
        SearchContext searchContext = new SearchContext(this.fragmentBuilders, aliasMap);
        searchContext.getSearchString().append(this.includeReturnFieldsInSearchString(context, returnFields));
        SearchFragmentBuilder builder = searchContext.getFragmentBuilder(filter);
        if (builder == null) {
            throw new UnrecognizedFilterException("No SearchFragmentBuilder can be retrieved.", filter);
        }
        builder.buildSearch(filter, searchContext);
        return searchContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object search(String context, Filter filter, List returnFields, Map aliasMap) throws PersistenceOperationException, UnrecognizedFilterException {
        if (context == null) {
            throw new IllegalArgumentException("The context should not be null.");
        }
        if (context.trim().length() == 0) {
            throw new IllegalArgumentException("The context should not be empty.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("The context should not be null.");
        }
        SearchBuilderHelper.checkList(returnFields, "returnFields", class$java$lang$String == null ? (class$java$lang$String = DatabaseSearchStrategy.class$("java.lang.String")) : class$java$lang$String);
        SearchBuilderHelper.checkaliasMap(aliasMap, "aliasMap");
        SearchContext searchContext = this.buildSearchContext(context, filter, returnFields, aliasMap);
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            connection = this.connectionName != null && this.connectionName.trim().length() > 0 ? this.connectionFactory.createConnection(this.connectionName) : this.connectionFactory.createConnection();
            ps = connection.prepareStatement(searchContext.getSearchString().toString());
            List list = searchContext.getBindableParameters();
            int index = 1;
            Iterator it = list.iterator();
            while (true) {
                if (!it.hasNext()) {
                    resultSet = ps.executeQuery();
                    CustomResultSet customResultSet = new CustomResultSet(resultSet);
                    this.doClose(connection, ps, resultSet);
                    return customResultSet;
                }
                Object obj = it.next();
                ps.setObject(index++, obj);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceOperationException("SQLException occurs.", e);
                catch (DBConnectionException e2) {
                    throw new PersistenceOperationException("Can not get the connection.", e2);
                }
            }
            catch (Throwable throwable) {
                this.doClose(connection, ps, resultSet);
                throw throwable;
            }
        }
    }

    private void doClose(Connection connection, PreparedStatement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            System.out.println("closed failed.");
        }
    }

    private String includeReturnFieldsInSearchString(String context, List fields) {
        if (fields.size() == 0) {
            return context + " ";
        }
        StringBuffer buffer = new StringBuffer();
        if (fields.size() > 0) {
            Iterator it = fields.iterator();
            buffer.append((String)it.next());
            while (it.hasNext()) {
                buffer.append(",").append((String)it.next());
            }
        }
        String returnFields = buffer.toString();
        int indexSelect = context.toLowerCase().indexOf("select");
        int indexFrom = context.toLowerCase().indexOf("from");
        if (indexSelect < 0 || indexFrom < 0) {
            throw new IllegalArgumentException("The searchString should contain the 'select' token to includeReturnFieldsInSearchString.");
        }
        String filedNames = context.substring(indexSelect + "select".length(), indexFrom).trim();
        if (filedNames.equals("*")) {
            return context + " ";
        }
        buffer = new StringBuffer();
        buffer.append("select ").append(filedNames);
        if (filedNames.length() != 0) {
            buffer.append(", ");
        }
        buffer.append(returnFields).append(" ").append(context.substring(indexFrom)).append(" ");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

