/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder.database;

import com.topcoder.db.connectionfactory.ConnectionProducer;
import com.topcoder.db.connectionfactory.DBConnectionException;
import com.topcoder.search.builder.ConnectionInformation;
import com.topcoder.search.builder.ConnectionStrategy;
import com.topcoder.search.builder.PersistenceOperationException;
import com.topcoder.search.builder.database.DataBaseHelper;
import com.topcoder.util.sql.databaseabstraction.CustomResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class DatabaseConnectionStrategy
extends ConnectionStrategy {
    private Connection connection = null;
    private PreparedStatement statement = null;

    public DatabaseConnectionStrategy(ConnectionInformation connectionInfo) {
        super(connectionInfo);
    }

    public synchronized Object search(String searchString, List fields) throws PersistenceOperationException {
        if (searchString == null) {
            throw new NullPointerException("The searchString should not be null to search in DatabaseConnectionStrategy.");
        }
        if (searchString.length() == 0) {
            throw new IllegalArgumentException("The searchString should not be empty to search in DatabaseConnectionStrategy.");
        }
        this.checkFileds(fields);
        try {
            if (this.connection == null) {
                this.connect();
            }
            String completeString = this.includeReturnFieldsInSearchString(searchString, fields);
            return this.searchDataStore(completeString);
        }
        catch (PersistenceOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceOperationException("exception occurs while do search in DatabaseConnectionStrategy.", e);
        }
    }

    public synchronized void compileStatement(String statement) throws PersistenceOperationException {
        if (statement == null) {
            throw new NullPointerException("The statement should not be null to compileStatement in DatabaseConnectionStrategy.");
        }
        if (statement.length() == 0) {
            throw new IllegalArgumentException("The statement should not be empty to compileStatement in DatabaseConnectionStrategy.");
        }
        try {
            if (this.connection == null) {
                this.connect();
            }
            this.statement = this.connection.prepareStatement(statement);
        }
        catch (SQLException e) {
            throw new PersistenceOperationException("SQLException occurs while compileStatementdo get prepareStatement in DatabaseConnectionStrategy.", e);
        }
    }

    public synchronized CustomResultSet executePrecompiledStatement(List parameters) throws PersistenceOperationException {
        if (parameters == null) {
            throw new NullPointerException("The list of parameters should not be null to do executePrecompiledStatement.");
        }
        try {
            int ind = 1;
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                this.statement.setObject(ind, it.next());
                ++ind;
            }
            return new CustomResultSet(this.statement.executeQuery());
        }
        catch (SQLException e) {
            throw new PersistenceOperationException("SQLException occurs while do executePrecompiledStatement.", e);
        }
    }

    public synchronized void close() throws PersistenceOperationException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenceOperationException("SQLException occurs while colse the connection in DatabaseConnectionStrategy.");
        }
    }

    protected synchronized Object searchDataStore(String searchString) throws PersistenceOperationException {
        if (searchString == null) {
            throw new NullPointerException("The searchString should not be null to searchDataStore in DatabaseConnectionStrategy.");
        }
        if (searchString.length() == 0) {
            throw new IllegalArgumentException("The searchString should not be empty to searchDataStore in DatabaseConnectionStrategy.");
        }
        Statement st = null;
        try {
            st = this.connection.createStatement();
            ResultSet reslutSet = st.executeQuery(searchString);
            CustomResultSet customResultSet = new CustomResultSet(reslutSet);
            return customResultSet;
        }
        catch (SQLException e) {
            throw new PersistenceOperationException("SQLException occurs while searchDataStore to get CustomResultSet", e);
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {}
        }
    }

    protected synchronized void connect() throws PersistenceOperationException {
        if (this.connection != null) {
            return;
        }
        try {
            ConnectionProducer dbf = (ConnectionProducer)this.connectionInfo.getFactory();
            this.connection = dbf.createConnection();
        }
        catch (DBConnectionException e) {
            throw new PersistenceOperationException("DBConnectionException occurs while get connection.", e);
        }
    }

    protected String includeReturnFieldsInSearchString(String searchString, List fields) {
        if (searchString == null) {
            throw new NullPointerException("The searchString should not be null to includeReturnFieldsInSearchString.");
        }
        if (searchString.length() == 0) {
            throw new IllegalArgumentException("The searchString should not be empty to includeReturnFieldsInSearchString.");
        }
        this.checkFileds(fields);
        Iterator it = fields.iterator();
        StringBuffer buffer = new StringBuffer((String)it.next());
        while (it.hasNext()) {
            buffer.append(",").append((String)it.next());
        }
        String s = buffer.toString();
        int index1 = searchString.toLowerCase().indexOf("select");
        int index2 = searchString.toLowerCase().indexOf("from");
        if (index1 < 0 || index2 < 0) {
            throw new IllegalArgumentException("The searchString should contain the 'select' token to includeReturnFieldsInSearchString.");
        }
        String filedNames = searchString.substring(index1 + "select".length(), index2).trim();
        if (filedNames.equalsIgnoreCase("*")) {
            return searchString;
        }
        if (filedNames.length() != 0) {
            filedNames = filedNames + ",";
        }
        buffer = new StringBuffer();
        buffer.append("select ").append(filedNames).append(s);
        buffer.append(" ").append(searchString.substring(index2));
        return buffer.toString();
    }

    private void checkFileds(List fields) {
        DataBaseHelper.checkList(fields, "fields");
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Object nextItem = it.next();
            if (!(nextItem instanceof String)) {
                throw new IllegalArgumentException("The value in the fields should be instance of String.");
            }
            if (((String)nextItem).length() != 0) continue;
            throw new IllegalArgumentException("The value in the fields should not be empty to search.");
        }
    }
}

