/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder;

import com.topcoder.search.builder.filter.Filter;

public class ValidationResult {
    private final boolean isResultValid;
    private final String message;
    private final Filter failedFilter;

    private ValidationResult(boolean isValid, String message, Filter filter) {
        if (message != null && message.length() == 0) {
            throw new IllegalArgumentException("The message should not empty to construct ValidationResult.");
        }
        this.isResultValid = isValid;
        this.message = message;
        this.failedFilter = filter;
    }

    public static synchronized ValidationResult createValidResult() {
        return new ValidationResult(true, null, null);
    }

    public static synchronized ValidationResult createInvalidResult(String message, Filter filter) {
        if (message == null) {
            throw new IllegalArgumentException("The message should not be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null to createInvalidResult.");
        }
        if (message.length() == 0) {
            throw new IllegalArgumentException("The message should not be empty to createInvalidResult.");
        }
        return new ValidationResult(false, message, filter);
    }

    public synchronized String getMessage() {
        return this.message;
    }

    public synchronized Filter getFailedFilter() {
        return (Filter)this.failedFilter.clone();
    }

    public synchronized boolean isValid() {
        return this.isResultValid;
    }
}

