/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder;

import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.util.classassociations.ClassAssociator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchContext {
    private final StringBuffer searchString;
    private final List bindableParameters;
    private final ClassAssociator fragmentBuilders;
    private Map aliasMap;

    public SearchContext(Map aliasMap) {
        this(null, aliasMap);
    }

    public SearchContext(ClassAssociator fragmentBuilderAssociations, Map aliasMap) {
        SearchBuilderHelper.checkaliasMap(aliasMap, "aliasMap");
        this.aliasMap = new HashMap(aliasMap);
        this.fragmentBuilders = fragmentBuilderAssociations;
        this.searchString = new StringBuffer();
        this.bindableParameters = new ArrayList();
    }

    public StringBuffer getSearchString() {
        return this.searchString;
    }

    public List getBindableParameters() {
        return this.bindableParameters;
    }

    public SearchFragmentBuilder getFragmentBuilder(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        if (this.fragmentBuilders != null) {
            return (SearchFragmentBuilder)this.fragmentBuilders.getAssociations().get(filter.getClass());
        }
        return null;
    }

    public String getFieldName(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("The alias String should not be null.");
        }
        if (alias.trim().length() == 0) {
            throw new IllegalArgumentException("The alias String should not be empty.");
        }
        return (String)this.aliasMap.get(alias);
    }
}

