/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder;

import com.topcoder.search.builder.DuplicatedElementsException;
import com.topcoder.search.builder.SearchBuilderConfigurationException;
import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchBundle;
import com.topcoder.search.builder.SearchStrategy;
import com.topcoder.util.config.Property;
import com.topcoder.util.objectfactory.InvalidClassSpecificationException;
import com.topcoder.util.objectfactory.ObjectFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SearchBundleManager {
    private Map searchBundleMap;

    public SearchBundleManager() {
        this.searchBundleMap = new HashMap();
    }

    public SearchBundleManager(String namespace) throws SearchBuilderConfigurationException {
        if (namespace == null) {
            throw new IllegalArgumentException("The namespace should not be null to construct SearchBundleManager.");
        }
        if (namespace.trim().length() == 0) {
            throw new IllegalArgumentException("The namespace should not be empty to construct SearchBundleManager.");
        }
        ObjectFactory strategyFactory = SearchBuilderHelper.getObjectFactory(namespace, "searchStrategyFactoryNamespace");
        ObjectFactory validatorFactory = SearchBuilderHelper.getObjectFactory(namespace, "fieldValidatorFactoryNamespace");
        this.searchBundleMap = new HashMap();
        Property searchBundles = SearchBuilderHelper.getConfigPropertyObject(namespace, "searchBundles", false);
        if (searchBundles == null) {
            return;
        }
        List subs = searchBundles.list();
        Iterator it = subs.iterator();
        while (it.hasNext()) {
            Property searchBundle = (Property)it.next();
            String name = searchBundle.getName();
            Map searchFields = SearchBundleManager.getFields(searchBundle, validatorFactory);
            SearchStrategy searchStrategy = SearchBundleManager.getSearchStrategy(searchBundle, strategyFactory);
            Map alias = SearchBundleManager.getAlias(searchBundle);
            String context = searchBundle.getValue("context");
            if (context == null || context.trim().length() == 0) {
                throw new SearchBuilderConfigurationException("The context should not be missing.");
            }
            SearchBundle bundle = null;
            try {
                bundle = new SearchBundle(name, searchFields, alias, context, searchStrategy);
            }
            catch (IllegalArgumentException e) {
                throw new SearchBuilderConfigurationException("failed to create the SearchBundle.", e);
            }
            this.searchBundleMap.put(name, bundle);
        }
    }

    private static SearchStrategy getSearchStrategy(Property property, ObjectFactory factory) throws SearchBuilderConfigurationException {
        String key = property.getValue("searchStrategy.class");
        if (key == null || key.trim().length() == 0) {
            throw new SearchBuilderConfigurationException("Property 'searchStrategy.class' is missing for validator.");
        }
        String identifier = property.getValue("searchStrategy.identifier");
        try {
            if (identifier == null || identifier.trim().length() == 0) {
                return (SearchStrategy)factory.createObject(key);
            }
            return (SearchStrategy)factory.createObject(key, identifier);
        }
        catch (Exception e) {
            throw new SearchBuilderConfigurationException("can not create the SearchStrategy.", e);
        }
    }

    private static Map getFields(Property property, ObjectFactory factory) throws SearchBuilderConfigurationException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Property fields = property.getProperty("searchableFields");
        if (fields == null) {
            throw new SearchBuilderConfigurationException("The 'searchableFields' should not be missed.");
        }
        List fieldList = fields.list();
        Iterator it = fieldList.iterator();
        while (it.hasNext()) {
            Property field = (Property)it.next();
            String name = field.getName();
            Property validatorProperty = field.getProperty("validator");
            if (validatorProperty == null) {
                map.put(name, null);
                continue;
            }
            String key = validatorProperty.getValue("class");
            if (key == null || key.trim().length() == 0) {
                throw new SearchBuilderConfigurationException("Property 'class' is missing for validator.");
            }
            String identifier = validatorProperty.getValue("identifier");
            try {
                if (identifier == null || identifier.trim().length() == 0) {
                    map.put(name, factory.createObject(key));
                    continue;
                }
                map.put(name, factory.createObject(key, identifier));
            }
            catch (InvalidClassSpecificationException e) {
                throw new SearchBuilderConfigurationException("faliled to create validator.", e);
            }
        }
        return map;
    }

    private static Map getAlias(Property property) throws SearchBuilderConfigurationException {
        HashMap<String, String> map = new HashMap<String, String>();
        Property aliases = property.getProperty("alias");
        if (aliases == null) {
            return map;
        }
        List aliasList = aliases.list();
        Iterator it = aliasList.iterator();
        while (it.hasNext()) {
            Property alias = (Property)it.next();
            map.put(alias.getName(), alias.getValue());
        }
        return map;
    }

    public synchronized SearchBundle getSearchBundle(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name should not be null to getSearchBundle.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("The name should not be empty to getSearchBundle.");
        }
        return (SearchBundle)this.searchBundleMap.get(name);
    }

    public synchronized List getSearchBundleNames() {
        return new ArrayList(this.searchBundleMap.keySet());
    }

    public synchronized void addSearchBundle(SearchBundle searchBundle) throws DuplicatedElementsException {
        if (searchBundle == null) {
            throw new IllegalArgumentException("The searchBundle should not be null to addSearchBundle.");
        }
        String searchBundleName = searchBundle.getName();
        if (this.searchBundleMap.containsKey(searchBundleName)) {
            throw new DuplicatedElementsException("The SearchBundle with name:" + searchBundleName + " already exist while do addSearchBundle.");
        }
        this.searchBundleMap.put(searchBundleName, searchBundle);
    }

    public synchronized void removeSearchBundle(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name should not be null to removeSearchBundle.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The name should not be empty to removeSearchBundle.");
        }
        this.searchBundleMap.remove(name);
    }

    public synchronized void setSearchBundle(Map searchBundleMap) {
        SearchBuilderHelper.checkSearchBundleMap(searchBundleMap, "searchBundleMap");
        this.searchBundleMap = new HashMap(searchBundleMap);
    }

    public synchronized void clear() {
        this.searchBundleMap.clear();
    }
}

