/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder;

import com.topcoder.search.builder.AlwaysTrueValidator;
import com.topcoder.search.builder.ConnectionStrategy;
import com.topcoder.search.builder.OperationNotSupportedException;
import com.topcoder.search.builder.PersistenceOperationException;
import com.topcoder.search.builder.SearchBuilderException;
import com.topcoder.search.builder.SearchBuilderHelper;
import com.topcoder.search.builder.SearchStrategy;
import com.topcoder.search.builder.SearchStringBuilder;
import com.topcoder.search.builder.ValidationResult;
import com.topcoder.search.builder.filter.AndFilter;
import com.topcoder.search.builder.filter.BetweenFilter;
import com.topcoder.search.builder.filter.EqualToFilter;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.search.builder.filter.GreaterThanFilter;
import com.topcoder.search.builder.filter.GreaterThanOrEqualToFilter;
import com.topcoder.search.builder.filter.InFilter;
import com.topcoder.search.builder.filter.LessThanFilter;
import com.topcoder.search.builder.filter.LessThanOrEqualToFilter;
import com.topcoder.search.builder.filter.LikeFilter;
import com.topcoder.search.builder.filter.NotFilter;
import com.topcoder.search.builder.filter.OrFilter;
import com.topcoder.util.sql.databaseabstraction.CustomResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SearchBundle {
    private final String name;
    private final String context;
    private Map searchableFields;
    private final Map aliasMap;
    private SearchStrategy searchStrategy;

    public SearchBundle(String name, Map fields, Map alias, String context) {
        if (name == null) {
            throw new IllegalArgumentException("The name should not be null to construct SearchBundle.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("The name should not be empty to construct SearchBundle.");
        }
        if (context == null) {
            throw new IllegalArgumentException("The context should not be null to construct SearchBundle.");
        }
        if (context.trim().length() == 0) {
            throw new IllegalArgumentException("The context should not be empty to construct SearchBundle.");
        }
        SearchBuilderHelper.checkaliasMap(alias, "alias");
        this.name = name;
        this.context = context;
        this.setSearchableFields(fields);
        this.aliasMap = new HashMap(alias);
        this.searchStrategy = null;
    }

    public SearchBundle(String name, Map alias, String context) {
        if (name == null) {
            throw new IllegalArgumentException("The param should not be null to construct SearchBundle.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("The param should not be empty to construct SearchBundle.");
        }
        if (context == null) {
            throw new IllegalArgumentException("The context should not be null to construct SearchBundle.");
        }
        if (context.trim().length() == 0) {
            throw new IllegalArgumentException("The context should not be empty to construct SearchBundle.");
        }
        SearchBuilderHelper.checkaliasMap(alias, "alias");
        this.name = name;
        this.context = context;
        this.aliasMap = new HashMap(alias);
        this.searchableFields = null;
        this.searchStrategy = null;
    }

    public SearchBundle(String name, Map fields, String context, SearchStrategy searchStrategy) {
        this(name, fields, new HashMap(), context);
        this.setSearchStrategy(searchStrategy);
    }

    public SearchBundle(String name, Map fields, Map alias, String context, SearchStrategy searchStrategy) {
        this(name, fields, alias, context);
        this.setSearchStrategy(searchStrategy);
    }

    public Object search(Filter filter) throws SearchBuilderException {
        return this.search(filter, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object search(Filter filter, List returnFields) throws SearchBuilderException {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        if (returnFields == null) {
            throw new IllegalArgumentException("The returnFields should not be null.");
        }
        ValidationResult result = null;
        try {
            result = this.validateFilter(filter);
        }
        catch (Exception e) {
            throw new PersistenceOperationException("Exception occurs while do the validateFilter to search in SearchBundle.", e);
        }
        if (!result.isValid()) {
            throw new SearchBuilderException("The filter to search is invalid in SearchBundle.");
        }
        try {
            SearchBundle e = this;
            synchronized (e) {
                return this.searchStrategy.search(this.context, filter, returnFields, this.aliasMap);
            }
        }
        catch (Exception e) {
            throw new PersistenceOperationException("Exception occurs while get the searchString and do search with returnfields in SearchBundle.", e);
        }
    }

    public static Filter buildGreaterThanFilter(String name, Comparable value) {
        return new GreaterThanFilter(name, value);
    }

    public static Filter buildLessThanFilter(String name, Comparable value) {
        return new LessThanFilter(name, value);
    }

    public static Filter buildGreaterThanOrEqualToFilter(String name, Comparable value) {
        return new GreaterThanOrEqualToFilter(name, value);
    }

    public static Filter buildLessThanOrEqualToFilter(String name, Comparable value) {
        return new LessThanOrEqualToFilter(name, value);
    }

    public static Filter buildEqualToFilter(String name, Comparable value) {
        return new EqualToFilter(name, value);
    }

    public static Filter buildBetweenFilter(String name, Comparable upper, Comparable lower) {
        return new BetweenFilter(name, upper, lower);
    }

    public static Filter buildInFilter(String name, List values) {
        return new InFilter(name, values);
    }

    public static Filter buildAndFilter(Filter first, Filter second) {
        return new AndFilter(first, second);
    }

    public static Filter buildOrFilter(Filter first, Filter second) {
        return new OrFilter(first, second);
    }

    public static Filter buildNotFilter(Filter filter) {
        return new NotFilter(filter);
    }

    public static Filter buildLikeFilter(String name, String value) {
        return new LikeFilter(name, value);
    }

    public static Filter buildLikeFilter(String name, String value, char escapeCharacter) {
        return new LikeFilter(name, value, escapeCharacter);
    }

    public synchronized void setSearchableFields(Map fields) {
        SearchBuilderHelper.checkfieldsMap(fields, "fields");
        this.searchableFields = new HashMap(fields);
        Iterator it = this.searchableFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != null) continue;
            entry.setValue(new AlwaysTrueValidator());
        }
    }

    public ValidationResult validateFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The filter should not be null.");
        }
        return filter.isValid(this.searchableFields, this.aliasMap);
    }

    public synchronized void compileStatement(String statement) {
    }

    public synchronized CustomResultSet executePrecompiledStatement(List parameters) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("The method is not supported in version 1.3.");
    }

    public String getName() {
        return this.name;
    }

    public SearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    public synchronized void setSearchStrategy(SearchStrategy searchStrategy) {
        if (searchStrategy == null) {
            throw new IllegalArgumentException("The searchStrategy should not be null.");
        }
        this.searchStrategy = searchStrategy;
    }

    public synchronized void setSearchStringBuilder(SearchStringBuilder builder) {
    }

    public synchronized void setConnectionStrategy(ConnectionStrategy strategy) {
    }

    protected String getSearchString(Filter filter) {
        return null;
    }
}

