/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder;

import com.topcoder.search.builder.SearchBuilderConfigurationException;
import com.topcoder.search.builder.SearchBundle;
import com.topcoder.search.builder.SearchContext;
import com.topcoder.search.builder.SearchFragmentBuilder;
import com.topcoder.search.builder.UnrecognizedFilterException;
import com.topcoder.search.builder.filter.AbstractAssociativeFilter;
import com.topcoder.search.builder.filter.AbstractSimpleFilter;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.util.classassociations.ClassAssociator;
import com.topcoder.util.classassociations.IllegalHandlerException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.datavalidator.ObjectValidator;
import com.topcoder.util.objectfactory.InvalidClassSpecificationException;
import com.topcoder.util.objectfactory.ObjectFactory;
import com.topcoder.util.objectfactory.SpecificationFactory;
import com.topcoder.util.objectfactory.impl.ConfigManagerSpecificationFactory;
import com.topcoder.util.objectfactory.impl.IllegalReferenceException;
import com.topcoder.util.objectfactory.impl.SpecificationConfigurationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SearchBuilderHelper {
    static /* synthetic */ Class class$com$topcoder$search$builder$filter$Filter;

    private SearchBuilderHelper() {
    }

    public static ObjectFactory getObjectFactory(String namespace, String propertyName) throws SearchBuilderConfigurationException {
        String factoryNS = SearchBuilderHelper.getConfigProperty(namespace, propertyName, true);
        try {
            ConfigManagerSpecificationFactory specificationFactory = new ConfigManagerSpecificationFactory(factoryNS);
            return new ObjectFactory((SpecificationFactory)specificationFactory);
        }
        catch (SpecificationConfigurationException e) {
            throw new SearchBuilderConfigurationException("can not get the Object Factory for SpecificationConfigurationException.", e);
        }
        catch (IllegalReferenceException e) {
            throw new SearchBuilderConfigurationException("can not get the Object Factory for IllegalReferenceException.", e);
        }
    }

    public static ClassAssociator loadClassAssociator(String namespace) throws SearchBuilderConfigurationException {
        ClassAssociator fragmentBuilders = new ClassAssociator();
        try {
            ObjectFactory objectFactory = SearchBuilderHelper.getObjectFactory(namespace, "searchFragmentFactoryNamespace");
            Property searchFragmentBuilders = SearchBuilderHelper.getConfigPropertyObject(namespace, "searchFragmentBuilders", false);
            if (searchFragmentBuilders != null) {
                List subProperties = searchFragmentBuilders.list();
                Iterator it = subProperties.iterator();
                while (it.hasNext()) {
                    Property searchFragmentBuilder;
                    Class<?> filterClass;
                    if (!(class$com$topcoder$search$builder$filter$Filter == null ? SearchBuilderHelper.class$("com.topcoder.search.builder.filter.Filter") : class$com$topcoder$search$builder$filter$Filter).isAssignableFrom(filterClass = Class.forName((searchFragmentBuilder = (Property)it.next()).getValue("targetFilter")))) {
                        throw new SearchBuilderConfigurationException("invalid filter class.");
                    }
                    String key = searchFragmentBuilder.getValue("className");
                    if (key == null || key.trim().length() == 0) {
                        throw new SearchBuilderConfigurationException("missing key for searchFragmentBuilder.");
                    }
                    String identifier = searchFragmentBuilder.getValue("identifier");
                    Object builder = null;
                    builder = identifier != null && identifier.trim().length() > 0 ? objectFactory.createObject(key, identifier) : objectFactory.createObject(key);
                    if (!(builder instanceof SearchFragmentBuilder)) {
                        throw new SearchBuilderConfigurationException("invalid searchFragmentBuilder class.");
                    }
                    fragmentBuilders.addClassAssociation(filterClass, builder);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new SearchBuilderConfigurationException("ClassNotFoundException occurs.", e);
        }
        catch (InvalidClassSpecificationException e) {
            throw new SearchBuilderConfigurationException("InvalidClassSpecificationException occurs.", e);
        }
        catch (IllegalHandlerException e) {
            throw new SearchBuilderConfigurationException("IllegalHandlerException occurs.", e);
        }
        catch (Exception e) {
            if (e instanceof SearchBuilderConfigurationException) {
                throw (SearchBuilderConfigurationException)((Object)e);
            }
            throw new SearchBuilderConfigurationException("Exception occurs.", e);
        }
        return fragmentBuilders;
    }

    public static String getConfigProperty(String namespace, String propertyName, boolean mandatory) throws SearchBuilderConfigurationException {
        String value;
        try {
            value = ConfigManager.getInstance().getString(namespace, propertyName);
        }
        catch (UnknownNamespaceException e) {
            throw new SearchBuilderConfigurationException("The namespace '" + namespace + "' is missing in configuration.", e);
        }
        if ((value == null || value.trim().length() == 0) && mandatory) {
            throw new SearchBuilderConfigurationException(propertyName + " is missing in configuration.");
        }
        return value;
    }

    public static Property getConfigPropertyObject(String namespace, String propertyName, boolean mandatory) throws SearchBuilderConfigurationException {
        Property value;
        try {
            value = ConfigManager.getInstance().getPropertyObject(namespace, propertyName);
        }
        catch (UnknownNamespaceException e) {
            throw new SearchBuilderConfigurationException("The namespace '" + namespace + "' is missing in configuration.", e);
        }
        if (value == null && mandatory) {
            throw new SearchBuilderConfigurationException(propertyName + " is missing in configuration.");
        }
        return value;
    }

    public static final String getRealName(String alias, SearchContext searchContext) {
        String realName = searchContext.getFieldName(alias);
        if (realName == null) {
            realName = alias;
        }
        return realName;
    }

    public static void buildDBSimpleFilter(AbstractSimpleFilter filter, String operateKey, SearchContext searchContext, Object value) throws UnrecognizedFilterException {
        StringBuffer buffer = searchContext.getSearchString();
        buffer.append(SearchBuilderHelper.getRealName(filter.getName(), searchContext));
        buffer.append(" ").append(operateKey).append(" ?");
        searchContext.getBindableParameters().add(value);
    }

    public static void buildDBAbstractAssociativeFilter(AbstractAssociativeFilter filter, String connectKey, SearchContext searchContext) throws UnrecognizedFilterException {
        StringBuffer buffer = searchContext.getSearchString();
        buffer.append("(");
        boolean isFirst = true;
        Iterator it = filter.getFilters().iterator();
        while (it.hasNext()) {
            Filter innerFilter = (Filter)it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(" " + connectKey + " ");
            }
            SearchFragmentBuilder builder = searchContext.getFragmentBuilder(innerFilter);
            if (builder == null) {
                throw new UnrecognizedFilterException("No SearchFragmentBuilder is looked up.", innerFilter);
            }
            builder.buildSearch(innerFilter, searchContext);
        }
        buffer.append(")");
    }

    public static void buildLDAPSimpleFilter(AbstractSimpleFilter filter, String operateKey, SearchContext searchContext, Object value) throws UnrecognizedFilterException {
        StringBuffer buffer = searchContext.getSearchString();
        buffer.append("(");
        buffer.append(SearchBuilderHelper.getRealName(filter.getName(), searchContext));
        buffer.append(operateKey).append(String.valueOf(value));
        buffer.append(")");
    }

    public static void buildLDAPAbstractAssociativeFilter(AbstractAssociativeFilter filter, String connectKey, SearchContext searchContext) throws UnrecognizedFilterException {
        StringBuffer buffer = searchContext.getSearchString();
        int initLength = buffer.toString().length();
        Iterator it = filter.getFilters().iterator();
        if (!it.hasNext()) {
            return;
        }
        Filter innerFilter = (Filter)it.next();
        SearchFragmentBuilder builder = searchContext.getFragmentBuilder(innerFilter);
        if (builder == null) {
            throw new UnrecognizedFilterException("No SearchFragmentBuilder is looked up.", innerFilter);
        }
        builder.buildSearch(innerFilter, searchContext);
        while (it.hasNext()) {
            innerFilter = (Filter)it.next();
            buffer.insert(initLength, "(" + connectKey);
            builder = searchContext.getFragmentBuilder(innerFilter);
            if (builder == null) {
                throw new UnrecognizedFilterException("No SearchFragmentBuilder is looked up.", innerFilter);
            }
            builder.buildSearch(innerFilter, searchContext);
            buffer.append(")");
        }
    }

    public static void checkList(List list, String listName, Class expectedClass) {
        if (list == null) {
            throw new IllegalArgumentException("The list " + listName + " should not be null.");
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null) {
                throw new IllegalArgumentException("The items in the list " + listName + " should not be null.");
            }
            if (!expectedClass.isAssignableFrom(obj.getClass())) {
                throw new IllegalArgumentException("The items in the list " + listName + " is invalid.");
            }
            if (!(obj instanceof String) || String.valueOf(obj).trim().length() != 0) continue;
            throw new IllegalArgumentException("The String in the list " + listName + " should not be empty.");
        }
    }

    public static void checkaliasMap(Map map, String mapName) {
        if (map == null) {
            throw new IllegalArgumentException("The " + mapName + " should not be null.");
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("The key in the list " + mapName + " illegal.");
            }
            Object value = entry.getValue();
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("The value in the list " + mapName + " illegal.");
            }
            if (key.toString().trim().length() != 0 && value.toString().trim().length() != 0) continue;
            throw new IllegalArgumentException("Both the key and value in the list " + mapName + " should not be" + " empty.");
        }
    }

    public static void checkfieldsMap(Map map, String mapName) {
        if (map == null) {
            throw new IllegalArgumentException("The " + mapName + " should not be null.");
        }
        if (map.size() == 0) {
            throw new IllegalArgumentException("The " + mapName + " should not be empty.");
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            if (key == null || !(key instanceof String)) {
                throw new IllegalArgumentException("The key in the list " + mapName + " illegal.");
            }
            Object value = entry.getValue();
            if (value == null || value instanceof ObjectValidator) continue;
            throw new IllegalArgumentException("The value in the list " + mapName + " illegal.");
        }
    }

    public static void checkSearchBundleMap(Map map, String mapName) {
        if (map == null) {
            throw new IllegalArgumentException("The " + mapName + " should not be null.");
        }
        if (map.size() == 0) {
            throw new IllegalArgumentException("The " + mapName + " should not be empty.");
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            if (key == null || !(key instanceof String)) {
                throw new IllegalArgumentException("The key in the list " + mapName + " illegal.");
            }
            Object value = entry.getValue();
            if (value != null && value instanceof SearchBundle) continue;
            throw new IllegalArgumentException("The value in the list " + mapName + " illegal.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

