/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.search.builder;

import com.topcoder.search.builder.ConnectionInformation;
import com.topcoder.search.builder.PersistenceOperationException;
import java.util.List;

public abstract class ConnectionStrategy {
    protected final ConnectionInformation connectionInfo;

    protected ConnectionStrategy(ConnectionInformation connectionInfo) {
        if (connectionInfo == null) {
            throw new NullPointerException("The ConnectionInformation should not be null to construct ConnectionStrategy");
        }
        this.connectionInfo = connectionInfo;
    }

    public synchronized Object search(String searchString) throws PersistenceOperationException {
        if (searchString == null) {
            throw new IllegalArgumentException("The searchString should not be null");
        }
        if (searchString.length() == 0) {
            throw new IllegalArgumentException("The searchString should not be empty");
        }
        this.connect();
        return this.searchDataStore(searchString);
    }

    public abstract Object search(String var1, List var2) throws PersistenceOperationException;

    public abstract void close() throws PersistenceOperationException;

    protected abstract void connect() throws PersistenceOperationException;

    protected abstract Object searchDataStore(String var1) throws PersistenceOperationException;
}

