/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.ConfigParserException;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.PluggableConfigSource;
import com.topcoder.util.config.Property;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

class PluggableConfigProperties
extends ConfigProperties {
    private PluggableConfigSource source = null;

    private PluggableConfigProperties() {
    }

    protected PluggableConfigProperties(URL file) throws ConfigManagerException, IOException {
        Object object;
        Properties properties = new Properties();
        InputStream stream = null;
        try {
            stream = file.openStream();
            properties.load(stream);
        }
        catch (IOException ioe) {
            throw new ConfigManagerException("can not load config file");
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        String className = properties.getProperty("classname");
        if (className == null) {
            throw new ConfigManagerException("config file does not contain the classname");
        }
        try {
            object = Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            throw new ConfigManagerException("unable to instantiate : " + exception.getMessage());
        }
        if (!(object instanceof PluggableConfigSource)) {
            throw new ConfigManagerException("incorrect object type");
        }
        this.source = (PluggableConfigSource)object;
        this.source.configure(properties);
        this.load();
    }

    protected void save() throws IOException {
        this.source.save(this.getRoot());
    }

    protected void load() throws IOException {
        List list = this.source.getProperties();
        Property root = new Property();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Object object = itr.next();
            if (object instanceof Property) {
                root.addProperty((Property)object);
                continue;
            }
            throw new ConfigParserException("contains non Property instance");
        }
        this.setRoot(root);
    }

    public Object clone() {
        PluggableConfigProperties properties = new PluggableConfigProperties();
        properties.source = this.source;
        properties.setRoot((Property)this.getRoot().clone());
        return properties;
    }
}

