/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.date.workdays;

import com.topcoder.date.workdays.ConfigurationFileException;
import com.topcoder.date.workdays.Workdays;
import com.topcoder.date.workdays.WorkdaysUnitOfTime;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.UnknownNamespaceException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultWorkdays
implements Workdays {
    public static final String PROPERTIES_FILE_FORMAT = "properties";
    public static final String XML_FILE_FORMAT = "XML";
    private static final int DEFAULT_START_TIME_HOURS = 9;
    private static final int DEFAULT_START_TIME_MINUTES = 0;
    private static final int DEFAULT_END_TIME_HOURS = 17;
    private static final int DEFAULT_END_TIME_MINUTES = 0;
    private static final String START_TIME_HOURS_PROPERTY = "startTime.hours";
    private static final String START_TIME_MINUTES_PROPERTY = "startTime.minutes";
    private static final String END_TIME_HOURS_PROPERTY = "endTime.hours";
    private static final String END_TIME_MINUTES_PROPERTY = "endTime.minutes";
    private static final String IS_SATURDAY_WORKDAY_PROPERTY = "isSaturdayWorkday";
    private static final String IS_SUNDAY_WORKDAY_PROPERTY = "isSundayWorkday";
    private static final String NON_WORKDAYS_PROPERTY = "nonWorkdays";
    private static final String LOCALE_LANGUAGE_PROPERTY = "locale.language";
    private static final String LOCALE_COUNTRY_PROPERTY = "locale.country";
    private static final String LOCALE_VARIANT_PROPERTY = "locale.variant";
    private static final String DATE_STYLE_PROPERTY = "dateStyle";
    private String namespace = null;
    private String fileName = null;
    private String fileFormat = "XML";
    private SortedSet nonWorkDays = new TreeSet();
    private SortedSet nonWorkSaturdayDays = new TreeSet();
    private SortedSet nonWorkSundayDays = new TreeSet();
    private boolean isSaturdayWorkday = false;
    private boolean isSundayWorkday = false;
    private int startTimeHours = 9;
    private int startTimeMinutes = 0;
    private int endTimeHours = 17;
    private int endTimeMinutes = 0;
    private Locale locale = Locale.getDefault();
    private DateFormat dateFormat = DateFormat.getDateInstance();
    private ConfigManager configManager = ConfigManager.getInstance();

    public DefaultWorkdays() {
    }

    public DefaultWorkdays(String fileName, String fileFormat) throws ConfigurationFileException {
        if (fileName == null) {
            throw new NullPointerException("Parameter fileName is null");
        }
        if (fileFormat == null) {
            throw new NullPointerException("Parameter fileFormat is null");
        }
        if (fileName.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter fileName is empty");
        }
        if (!fileFormat.equals(XML_FILE_FORMAT) && !fileFormat.equals(PROPERTIES_FILE_FORMAT)) {
            throw new IllegalArgumentException("Parameter fileFormat is not one of the PROPERTIES_FILE_FORMAT and XML_FILE_FORMAT constants");
        }
        this.fileName = fileName;
        this.fileFormat = fileFormat;
        this.namespace = this.getNamespace(fileName);
        this.refresh();
    }

    public void refresh() throws ConfigurationFileException {
        this.startTimeHours = 9;
        this.startTimeMinutes = 0;
        this.endTimeHours = 17;
        this.endTimeMinutes = 0;
        this.locale = Locale.getDefault();
        this.dateFormat = DateFormat.getDateInstance();
        this.isSaturdayWorkday = false;
        this.isSundayWorkday = false;
        this.nonWorkDays.clear();
        this.nonWorkSaturdayDays.clear();
        this.nonWorkSundayDays.clear();
        if (this.fileName == null) {
            throw new IllegalArgumentException("No configuration file specified");
        }
        try {
            if (this.configManager.existsNamespace(this.namespace)) {
                this.configManager.refresh(this.namespace);
            } else if (this.fileFormat.equals(XML_FILE_FORMAT)) {
                this.configManager.add(this.namespace, this.fileName, ".xml");
            } else {
                this.configManager.add(this.namespace, this.fileName, ".properties");
            }
        }
        catch (ConfigManagerException cme) {
            throw new ConfigurationFileException("Errors occur when loading the namespace from the file", (Exception)((Object)cme));
        }
        try {
            this.setTimeByConfigManager();
            this.isSaturdayWorkday = this.getBoolValueOfProperty(IS_SATURDAY_WORKDAY_PROPERTY);
            this.isSundayWorkday = this.getBoolValueOfProperty(IS_SUNDAY_WORKDAY_PROPERTY);
            this.setLocaleByConfigManager();
            this.setDateFormatByConfigManager();
            String[] nonWorkdays = this.configManager.getStringArray(this.namespace, NON_WORKDAYS_PROPERTY);
            if (nonWorkdays != null) {
                for (int i = 0; i < nonWorkdays.length; ++i) {
                    this.addNonWorkday(this.dateFormat.parse(nonWorkdays[i].trim()));
                }
            }
        }
        catch (UnknownNamespaceException une) {
        }
        catch (ParseException pe) {
            throw new ConfigurationFileException("One of the nonworkdays in configuration file is not in required format", pe);
        }
        catch (IllegalArgumentException iae) {
            throw new ConfigurationFileException("Some properties are not in required format", iae);
        }
    }

    public void save() throws ConfigurationFileException {
        if (this.fileName == null) {
            throw new IllegalArgumentException("No configuration file specified");
        }
        try {
            if (!this.configManager.existsNamespace(this.namespace)) {
                File file = new File(this.fileName);
                file.createNewFile();
                if (this.fileFormat.equals(XML_FILE_FORMAT)) {
                    FileWriter writer = new FileWriter(file);
                    writer.write("<CMConfig></CMConfig>");
                    writer.close();
                    this.configManager.add(this.namespace, this.fileName, ".xml");
                } else {
                    this.configManager.add(this.namespace, this.fileName, ".properties");
                }
            }
            this.configManager.createTemporaryProperties(this.namespace);
            this.configManager.setProperty(this.namespace, START_TIME_HOURS_PROPERTY, String.valueOf(this.startTimeHours));
            this.configManager.setProperty(this.namespace, START_TIME_MINUTES_PROPERTY, String.valueOf(this.startTimeMinutes));
            this.configManager.setProperty(this.namespace, END_TIME_HOURS_PROPERTY, String.valueOf(this.endTimeHours));
            this.configManager.setProperty(this.namespace, END_TIME_MINUTES_PROPERTY, String.valueOf(this.endTimeMinutes));
            this.configManager.setProperty(this.namespace, IS_SATURDAY_WORKDAY_PROPERTY, String.valueOf(this.isSaturdayWorkday));
            this.configManager.setProperty(this.namespace, IS_SUNDAY_WORKDAY_PROPERTY, String.valueOf(this.isSundayWorkday));
            this.configManager.setProperty(this.namespace, LOCALE_LANGUAGE_PROPERTY, this.locale.getLanguage());
            this.configManager.setProperty(this.namespace, LOCALE_COUNTRY_PROPERTY, this.locale.getCountry());
            this.configManager.setProperty(this.namespace, LOCALE_VARIANT_PROPERTY, this.locale.getVariant());
            ArrayList<String> nonWorkdays = new ArrayList<String>();
            Iterator it = this.nonWorkDays.iterator();
            while (it.hasNext()) {
                nonWorkdays.add(this.dateFormat.format((Date)it.next()));
            }
            it = this.nonWorkSaturdayDays.iterator();
            while (it.hasNext()) {
                nonWorkdays.add(this.dateFormat.format((Date)it.next()));
            }
            it = this.nonWorkSundayDays.iterator();
            while (it.hasNext()) {
                nonWorkdays.add(this.dateFormat.format((Date)it.next()));
            }
            if (nonWorkdays.size() > 0) {
                this.configManager.setProperty(this.namespace, NON_WORKDAYS_PROPERTY, nonWorkdays.toArray(new String[0]));
            } else {
                this.configManager.removeProperty(this.namespace, NON_WORKDAYS_PROPERTY);
            }
            this.configManager.commit(this.namespace, this.namespace);
        }
        catch (ConfigManagerException cme) {
            throw new ConfigurationFileException("Something goes wrong in the process of saving to the configuration file", (Exception)((Object)cme));
        }
        catch (IOException ioe) {
            throw new ConfigurationFileException("Can't create file with the name " + this.fileName, ioe);
        }
    }

    public void addNonWorkday(Date nonWorkday) {
        if (nonWorkday == null) {
            throw new NullPointerException("Parameter nonWorkday is null");
        }
        Calendar nonWorkdayCal = Calendar.getInstance(this.locale);
        nonWorkdayCal.setTime(nonWorkday);
        nonWorkdayCal.set(11, 0);
        nonWorkdayCal.set(12, 0);
        nonWorkdayCal.set(13, 0);
        nonWorkdayCal.set(14, 0);
        if (nonWorkdayCal.get(7) == 7) {
            this.nonWorkSaturdayDays.add(nonWorkdayCal.getTime());
        } else if (nonWorkdayCal.get(7) == 1) {
            this.nonWorkSundayDays.add(nonWorkdayCal.getTime());
        } else {
            this.nonWorkDays.add(nonWorkdayCal.getTime());
        }
    }

    public void removeNonWorkday(Date nonWorkday) {
        if (nonWorkday == null) {
            throw new NullPointerException("Parameter nonWorkday is null");
        }
        Calendar nonWorkdayCal = Calendar.getInstance(this.locale);
        nonWorkdayCal.setTime(nonWorkday);
        nonWorkdayCal.set(11, 0);
        nonWorkdayCal.set(12, 0);
        nonWorkdayCal.set(13, 0);
        nonWorkdayCal.set(14, 0);
        boolean exist = this.nonWorkDays.remove(nonWorkday);
        if (!exist) {
            exist = this.nonWorkSaturdayDays.remove(nonWorkday);
        }
        if (!exist) {
            exist = this.nonWorkSundayDays.remove(nonWorkday);
        }
        if (!exist) {
            throw new IllegalArgumentException("nonWorkday does not exist");
        }
    }

    public Set getNonWorkdays() {
        TreeSet allNonWorkDays = new TreeSet();
        allNonWorkDays.addAll(this.nonWorkDays);
        allNonWorkDays.addAll(this.nonWorkSaturdayDays);
        allNonWorkDays.addAll(this.nonWorkSundayDays);
        return allNonWorkDays;
    }

    public void clearNonWorkdays() {
        this.nonWorkDays.clear();
        this.nonWorkSaturdayDays.clear();
        this.nonWorkSundayDays.clear();
    }

    public void setSaturdayWorkday(boolean isSaturdayWorkday) {
        this.isSaturdayWorkday = isSaturdayWorkday;
    }

    public boolean isSaturdayWorkday() {
        return this.isSaturdayWorkday;
    }

    public void setSundayWorkday(boolean isSundayWorkday) {
        this.isSundayWorkday = isSundayWorkday;
    }

    public boolean isSundayWorkday() {
        return this.isSundayWorkday;
    }

    public void setWorkdayStartTimeHours(int startTimeHours) {
        if (startTimeHours < 0 || startTimeHours > 24) {
            throw new IllegalArgumentException("Parameter startTimeHours is not a valid hour");
        }
        this.startTimeHours = startTimeHours;
        this.timeStateValidation();
    }

    public int getWorkdayStartTimeHours() {
        return this.startTimeHours;
    }

    public void setWorkdayStartTimeMinutes(int startTimeMinutes) {
        if (startTimeMinutes < 0 || startTimeMinutes >= 60) {
            throw new IllegalArgumentException("Parameter startTimeMinutes is not a valid hour");
        }
        this.startTimeMinutes = startTimeMinutes;
        this.timeStateValidation();
    }

    public int getWorkdayStartTimeMinutes() {
        return this.startTimeMinutes;
    }

    public void setWorkdayEndTimeHours(int endTimeHours) {
        if (endTimeHours < 0 || endTimeHours > 24) {
            throw new IllegalArgumentException("Parameter endTimeHours is not a valid hour");
        }
        this.endTimeHours = endTimeHours;
        this.timeStateValidation();
    }

    public int getWorkdayEndTimeHours() {
        return this.endTimeHours;
    }

    public void setWorkdayEndTimeMinutes(int endTimeMinutes) {
        if (endTimeMinutes < 0 || endTimeMinutes >= 60) {
            throw new IllegalArgumentException("Parameter endTimeMinutes is not a valid hour");
        }
        this.endTimeMinutes = endTimeMinutes;
        this.timeStateValidation();
    }

    public int getWorkdayEndTimeMinutes() {
        return this.endTimeMinutes;
    }

    public Date add(Date startDate, WorkdaysUnitOfTime unitOfTime, int amount) {
        long daysToAdd;
        if (startDate == null) {
            throw new NullPointerException("Parameter startDate is null");
        }
        if (unitOfTime == null) {
            throw new NullPointerException("Parameter unitOfTime is null");
        }
        if (amount < 0) {
            throw new IllegalArgumentException("Parameter amount is negative");
        }
        this.timeStateValidation();
        if (amount == 0) {
            return startDate;
        }
        Calendar startCal = Calendar.getInstance(this.locale);
        startCal.setTime(startDate);
        startCal.set(13, 0);
        startCal.set(14, 0);
        Calendar dayBegin = (Calendar)startCal.clone();
        Calendar dayEnd = (Calendar)startCal.clone();
        dayBegin.set(11, this.startTimeHours);
        dayBegin.set(12, this.startTimeMinutes);
        dayEnd.set(11, this.endTimeHours);
        dayEnd.set(12, this.endTimeMinutes);
        long workdayInMilliSeconds = (long)this.getWorkdayDurationInMinutes() * 60L * 1000L;
        long timeInMilliSeconds = (long)this.getAmountInMinutes(unitOfTime, amount) * 60L * 1000L;
        if (!this.isNonWorkday(startCal)) {
            if (startCal.after(dayEnd)) {
                timeInMilliSeconds += workdayInMilliSeconds;
            } else if (startCal.after(dayBegin)) {
                timeInMilliSeconds += startCal.getTime().getTime() - dayBegin.getTime().getTime();
            }
        }
        long min = daysToAdd = (timeInMilliSeconds + workdayInMilliSeconds - 1L) / workdayInMilliSeconds;
        long max = daysToAdd * 7L / 5L + (long)this.nonWorkDays.size() + (long)this.nonWorkSaturdayDays.size() + (long)this.nonWorkSundayDays.size() + 7L;
        startCal.set(11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        Date startDay = startCal.getTime();
        Date endDay = new Date();
        long mid = (min + max) / 2L;
        while (min <= max) {
            endDay.setTime(startDay.getTime() + mid * 24L * 60L * 60L * 1000L - 60000L);
            int workdaysCount = this.getWorkdaysCount(startDay, endDay);
            if ((long)workdaysCount >= daysToAdd) {
                max = mid - 1L;
            } else {
                min = mid + 1L;
            }
            mid = (min + max) / 2L;
        }
        long disToBegin = (timeInMilliSeconds + workdayInMilliSeconds - 1L) % workdayInMilliSeconds + 1L;
        endDay.setTime(dayBegin.getTime().getTime() + max * 24L * 60L * 60L * 1000L + disToBegin);
        return endDay;
    }

    public void setFileName(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("Parameter fileName is null");
        }
        if (fileName.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter fileName is emtpy");
        }
        this.fileName = fileName;
        if (this.namespace != null && this.configManager.existsNamespace(this.namespace)) {
            try {
                this.configManager.removeNamespace(this.namespace);
            }
            catch (UnknownNamespaceException unknownNamespaceException) {
                // empty catch block
            }
        }
        this.namespace = this.getNamespace(fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        if (fileFormat == null) {
            throw new NullPointerException("Parameter fileFormat is null");
        }
        if (!fileFormat.equals(PROPERTIES_FILE_FORMAT) && !fileFormat.equals(XML_FILE_FORMAT)) {
            throw new IllegalArgumentException("Parameter fileFormat is not one of the two file format constants");
        }
        this.fileFormat = fileFormat;
    }

    private int getAmountInMinutes(WorkdaysUnitOfTime unitOfTime, int amount) {
        if (((Object)((Object)unitOfTime)).equals((Object)WorkdaysUnitOfTime.MINUTES)) {
            return amount;
        }
        if (((Object)((Object)unitOfTime)).equals((Object)WorkdaysUnitOfTime.HOURS)) {
            return amount * 60;
        }
        return this.getWorkdayDurationInMinutes() * amount;
    }

    private int getWorkdayDurationInMinutes() {
        return this.endTimeHours * 60 + this.endTimeMinutes - this.startTimeHours * 60 - this.startTimeMinutes;
    }

    private int getWorkdaysCount(Date startDay, Date endDay) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDay);
        int total = (int)((endDay.getTime() - startDay.getTime() + 60000L) / 86400000L);
        int count = this.nonWorkDays.subSet(startDay, endDay).size();
        if (this.isSaturdayWorkday()) {
            count += this.nonWorkSaturdayDays.subSet(startDay, endDay).size();
        } else {
            int disToSaturday = (7 - startCal.get(7) + 7) % 7;
            count += (total - disToSaturday + 6) / 7;
        }
        if (this.isSundayWorkday()) {
            count += this.nonWorkSundayDays.subSet(startDay, endDay).size();
        } else {
            int disToSunday = (1 - startCal.get(7) + 7) % 7;
            count += (total - disToSunday + 6) / 7;
        }
        return total - count;
    }

    private boolean isNonWorkday(Calendar cal) {
        if (!this.isSaturdayWorkday() && cal.get(7) == 7) {
            return true;
        }
        if (!this.isSundayWorkday() && cal.get(7) == 1) {
            return true;
        }
        if (this.nonWorkDays.contains(cal.getTime())) {
            return true;
        }
        if (this.isSaturdayWorkday() && this.nonWorkSaturdayDays.contains(cal.getTime())) {
            return true;
        }
        return this.isSundayWorkday() && this.nonWorkSundayDays.contains(cal.getTime());
    }

    private String getNamespace(String fileName) {
        if (fileName.length() > 1 && fileName.charAt(1) == ':') {
            fileName = fileName.substring(2);
        }
        if (fileName.startsWith("\\") || fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        StringBuffer answer = new StringBuffer();
        fileName = fileName.replace('\\', '.').replace('/', '.');
        boolean dotFlag = true;
        for (int i = 0; i < fileName.length(); ++i) {
            if (fileName.charAt(i) == '.') {
                if (dotFlag) continue;
                answer.append('.');
                dotFlag = true;
                continue;
            }
            answer.append(fileName.charAt(i));
            dotFlag = false;
        }
        return answer.toString();
    }

    private void setTimeByConfigManager() {
        this.startTimeHours = this.getIntValueOfProperty(START_TIME_HOURS_PROPERTY, 0, 24);
        this.startTimeMinutes = this.getIntValueOfProperty(START_TIME_MINUTES_PROPERTY, 0, 59);
        this.endTimeHours = this.getIntValueOfProperty(END_TIME_HOURS_PROPERTY, 0, 24);
        this.endTimeMinutes = this.getIntValueOfProperty(END_TIME_MINUTES_PROPERTY, 0, 59);
        this.timeStateValidation();
    }

    private void setLocaleByConfigManager() {
        try {
            String language = this.configManager.getString(this.namespace, LOCALE_LANGUAGE_PROPERTY);
            String country = this.configManager.getString(this.namespace, LOCALE_COUNTRY_PROPERTY);
            String variant = this.configManager.getString(this.namespace, LOCALE_VARIANT_PROPERTY);
            if (language != null && country != null && variant != null) {
                this.locale = new Locale(language, country, variant);
            } else if (language != null && country != null) {
                this.locale = new Locale(language, country);
            }
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            // empty catch block
        }
    }

    private void setDateFormatByConfigManager() {
        try {
            String style = this.configManager.getString(this.namespace, DATE_STYLE_PROPERTY);
            this.dateFormat = style == null ? DateFormat.getDateInstance(2, this.locale) : (style.equalsIgnoreCase("SHORT") ? DateFormat.getDateInstance(3, this.locale) : (style.equalsIgnoreCase("MEDIUM") ? DateFormat.getDateInstance(2, this.locale) : (style.equalsIgnoreCase("LONG") ? DateFormat.getDateInstance(1, this.locale) : (style.equalsIgnoreCase("FULL") ? DateFormat.getDateInstance(0, this.locale) : DateFormat.getDateInstance(2, this.locale)))));
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            // empty catch block
        }
    }

    private int getIntValueOfProperty(String propertyName, int min, int max) {
        try {
            String stringValue = this.configManager.getString(this.namespace, propertyName);
            if (stringValue == null) {
                throw new IllegalArgumentException("Property " + propertyName + " is not specified");
            }
            int value = Integer.parseInt(stringValue);
            if (value < min || value > max) {
                throw new IllegalArgumentException("Property " + propertyName + " must be between " + min + " and " + max + "(inclusive)");
            }
            return value;
        }
        catch (UnknownNamespaceException une) {
            throw new IllegalArgumentException("Property " + propertyName + " is not specified");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Property " + propertyName + " is not a number");
        }
    }

    private boolean getBoolValueOfProperty(String propertyName) {
        try {
            String stringValue = this.configManager.getString(this.namespace, propertyName);
            if (stringValue == null) {
                throw new IllegalArgumentException("Property " + propertyName + " is not specified");
            }
            if (stringValue.equalsIgnoreCase("true")) {
                return true;
            }
            if (stringValue.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException("Property " + propertyName + " only can be true or false");
        }
        catch (UnknownNamespaceException une) {
            throw new IllegalArgumentException("Property " + propertyName + " is not specified");
        }
    }

    private void timeStateValidation() {
        if (this.startTimeHours == 24 && this.startTimeMinutes > 0) {
            throw new IllegalArgumentException("The start time is after 24:00");
        }
        if (this.endTimeHours == 24 && this.endTimeMinutes > 0) {
            throw new IllegalArgumentException("The end time is after 24:00");
        }
        if (this.startTimeHours > this.endTimeHours || this.startTimeHours == this.endTimeHours && this.startTimeMinutes >= this.endTimeMinutes) {
            throw new IllegalArgumentException("The start time is after the end time");
        }
    }
}

