/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.db.connectionfactory.producers;

import com.topcoder.configuration.ConfigurationAccessException;
import com.topcoder.configuration.ConfigurationObject;
import com.topcoder.db.connectionfactory.DBConnectionFactoryHelper;
import com.topcoder.db.connectionfactory.producers.DataSourceConnectionProducer;
import com.topcoder.util.config.Property;
import javax.sql.DataSource;

public class ReflectingConnectionProducer
extends DataSourceConnectionProducer {
    public static final String DATASOURCE_CLASS_PROPERTY = "datasource_class";

    public ReflectingConnectionProducer(String dataSourceClass) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        DBConnectionFactoryHelper.checkNullOrEmpty("dataSourceClass", dataSourceClass);
        this.createAndSetDataSource(dataSourceClass);
    }

    public ReflectingConnectionProducer(String dataSourceClass, String username, String password) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(dataSourceClass);
        this.setPassword(password);
        this.setUsername(username);
    }

    public ReflectingConnectionProducer(Property properties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(properties);
        String dataSourceClass = properties.getValue(DATASOURCE_CLASS_PROPERTY);
        if (dataSourceClass == null) {
            throw new IllegalArgumentException("Parameter properties do not contain datasource class.");
        }
        this.createAndSetDataSource(dataSourceClass);
    }

    public ReflectingConnectionProducer(ConfigurationObject configurationObject) throws ConfigurationAccessException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(configurationObject);
        Object dataSourceClass = configurationObject.getChild("parameters").getPropertyValue(DATASOURCE_CLASS_PROPERTY);
        if (!(dataSourceClass instanceof String)) {
            throw new IllegalArgumentException("The property[datasource_class] should exist and contain an string value.");
        }
        this.createAndSetDataSource((String)dataSourceClass);
    }

    private void createAndSetDataSource(String dataSourceClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.setDataSource((DataSource)Class.forName(dataSourceClass).newInstance());
    }
}

