/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.db.connectionfactory.producers;

import com.topcoder.configuration.ConfigurationAccessException;
import com.topcoder.configuration.ConfigurationObject;
import com.topcoder.db.connectionfactory.DBConnectionFactoryHelper;
import com.topcoder.db.connectionfactory.producers.DataSourceConnectionProducer;
import com.topcoder.util.config.Property;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JNDIConnectionProducer
extends DataSourceConnectionProducer {
    public static final String JNDI_NAME_PROPERTY = "jndi_name";
    private static final char UNDERLINE = '_';
    private static final char DOT = '.';

    public JNDIConnectionProducer(String jndiName) throws NamingException {
        DBConnectionFactoryHelper.checkNullOrEmpty("jndiName", jndiName);
        this.setDataSource((DataSource)new InitialContext().lookup(jndiName));
    }

    public JNDIConnectionProducer(String jndiName, String username, String password) throws NamingException {
        this(jndiName);
        this.setUsername(username);
        this.setPassword(password);
    }

    public JNDIConnectionProducer(String jndiName, Hashtable environment) throws NamingException {
        DBConnectionFactoryHelper.checkNullOrEmpty("jndiName", jndiName);
        this.setDataSource((DataSource)new InitialContext(environment).lookup(jndiName));
    }

    public JNDIConnectionProducer(String jndiName, Hashtable environment, String username, String password) throws NamingException {
        this(jndiName, environment);
        this.setUsername(username);
        this.setPassword(password);
    }

    public JNDIConnectionProducer(Property properties) throws NamingException {
        super(properties);
        String jndiname = properties.getValue(JNDI_NAME_PROPERTY);
        if (jndiname == null) {
            throw new IllegalArgumentException("Parameter properties do not contain jndi name.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        Iterator it = properties.list().iterator();
        while (it.hasNext()) {
            Property prope = (Property)it.next();
            String name = prope.getName();
            env.put(name.replace('_', '.'), prope.getValue());
        }
        this.setDataSource((DataSource)new InitialContext(env).lookup(jndiname));
    }

    public JNDIConnectionProducer(ConfigurationObject configurationObject) throws ConfigurationAccessException, NamingException {
        super(configurationObject);
        ConfigurationObject parameters = configurationObject.getChild("parameters");
        Object jndiName = parameters.getPropertyValue(JNDI_NAME_PROPERTY);
        if (!(jndiName instanceof String)) {
            throw new IllegalArgumentException("The property[jndi_name] should exist and contain a string value.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        String[] keys = parameters.getAllPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            String value = DBConnectionFactoryHelper.getNullOrStringValueFromConfigurationObject(parameters, keys[i]);
            if (value == null) continue;
            env.put(keys[i].replace('_', '.'), value);
        }
        this.setDataSource((DataSource)new InitialContext(env).lookup((String)jndiName));
    }
}

