/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.db.connectionfactory.producers;

import com.topcoder.configuration.ConfigurationAccessException;
import com.topcoder.configuration.ConfigurationObject;
import com.topcoder.db.connectionfactory.ConnectionProducer;
import com.topcoder.db.connectionfactory.DBConnectionException;
import com.topcoder.db.connectionfactory.DBConnectionFactoryHelper;
import com.topcoder.util.config.Property;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class JDBCConnectionProducer
implements ConnectionProducer {
    public static final String USERNAME_PROPERTY = "user";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String JDBC_URL_PROPERTY = "jdbc_url";
    public static final String JDBC_DRIVER_CLASS_PROPERTY = "jdbc_driver";
    private static final String PARAMETERS = "parameters";
    private final String jdbcUrl;
    private final Properties connectionProperties;

    public JDBCConnectionProducer(String jdbcUrl) {
        DBConnectionFactoryHelper.checkNullOrEmpty("jdbcUrl", jdbcUrl);
        this.jdbcUrl = jdbcUrl;
        this.connectionProperties = new Properties();
    }

    public JDBCConnectionProducer(String jdbcUrl, String username, String password) {
        this(jdbcUrl);
        DBConnectionFactoryHelper.checkNull("username", username);
        DBConnectionFactoryHelper.checkNull(PASSWORD_PROPERTY, password);
        this.connectionProperties.put(USERNAME_PROPERTY, username);
        this.connectionProperties.put(PASSWORD_PROPERTY, password);
    }

    public JDBCConnectionProducer(String jdbcUrl, Properties properties) {
        DBConnectionFactoryHelper.checkNullOrEmpty("jdbcUrl", jdbcUrl);
        DBConnectionFactoryHelper.checkNull("properties", properties);
        this.jdbcUrl = jdbcUrl;
        this.connectionProperties = new Properties(properties);
    }

    public JDBCConnectionProducer(Property properties) throws ClassNotFoundException {
        DBConnectionFactoryHelper.checkNull("properties", properties);
        this.jdbcUrl = properties.getValue(JDBC_URL_PROPERTY);
        if (this.jdbcUrl == null) {
            throw new IllegalArgumentException("The jdbc url is absent.");
        }
        if (this.jdbcUrl.trim().length() == 0) {
            throw new IllegalArgumentException("The jdbc url should not be empty string.");
        }
        String driverClassName = properties.getValue(JDBC_DRIVER_CLASS_PROPERTY);
        if (driverClassName != null) {
            try {
                Class.forName(driverClassName);
            }
            catch (Exception e) {
                throw new ClassNotFoundException("The class name " + driverClassName + " is invalid.", e);
            }
        }
        this.connectionProperties = new Properties();
        List pro = properties.list();
        Iterator it = pro.iterator();
        while (it.hasNext()) {
            Property proper = (Property)it.next();
            this.connectionProperties.put(proper.getName(), proper.getValue());
        }
    }

    public JDBCConnectionProducer(ConfigurationObject configurationObject) throws ConfigurationAccessException, ClassNotFoundException {
        ConfigurationObject parameters = DBConnectionFactoryHelper.getChildFromConfigurationObject("configurationObject", configurationObject, PARAMETERS);
        Object value = parameters.getPropertyValue(JDBC_URL_PROPERTY);
        if (!(value instanceof String) || ((String)value).trim().length() == 0) {
            throw new IllegalArgumentException("Property value for key[jdbc_url] in child[parameters] must exist as a non-empty string.");
        }
        this.jdbcUrl = (String)value;
        value = DBConnectionFactoryHelper.getNullOrStringValueFromConfigurationObject(parameters, JDBC_DRIVER_CLASS_PROPERTY);
        if (value != null) {
            Class.forName((String)value);
        }
        this.connectionProperties = new Properties();
        String[] keys = parameters.getAllPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            value = DBConnectionFactoryHelper.getNullOrStringValueFromConfigurationObject(parameters, keys[i]);
            if (value == null) continue;
            this.connectionProperties.put(keys[i], value);
        }
    }

    public Connection createConnection() throws DBConnectionException {
        return this.createConnection(this.connectionProperties);
    }

    public Connection createConnection(String username, String password) throws DBConnectionException {
        Properties properties = new Properties(this.connectionProperties);
        properties.setProperty(USERNAME_PROPERTY, username);
        properties.setProperty(PASSWORD_PROPERTY, password);
        return this.createConnection(properties);
    }

    private Connection createConnection(Properties properties) throws DBConnectionException {
        try {
            return DriverManager.getConnection(this.jdbcUrl, properties);
        }
        catch (SQLException sqle) {
            throw new DBConnectionException("error occurs while creating the connection.", sqle);
        }
    }
}

