/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.db.connectionfactory.producers;

import com.topcoder.configuration.ConfigurationAccessException;
import com.topcoder.configuration.ConfigurationObject;
import com.topcoder.db.connectionfactory.ConnectionProducer;
import com.topcoder.db.connectionfactory.DBConnectionException;
import com.topcoder.db.connectionfactory.DBConnectionFactoryHelper;
import com.topcoder.util.config.Property;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceConnectionProducer
implements ConnectionProducer {
    public static final String USERNAME_PROPERTY = "username";
    public static final String PASSWORD_PROPERTY = "password";
    protected static final String PARAMETERS = "parameters";
    private DataSource dataSource = null;
    private String username = null;
    private String password = null;

    protected DataSourceConnectionProducer() {
    }

    protected DataSourceConnectionProducer(Property properties) {
        DBConnectionFactoryHelper.checkNull("properties", properties);
        this.username = properties.getValue(USERNAME_PROPERTY);
        this.password = properties.getValue(PASSWORD_PROPERTY);
    }

    protected DataSourceConnectionProducer(ConfigurationObject configurationObject) throws ConfigurationAccessException {
        ConfigurationObject parameters = DBConnectionFactoryHelper.getChildFromConfigurationObject("configurationObject", configurationObject, PARAMETERS);
        this.username = DBConnectionFactoryHelper.getNullOrStringValueFromConfigurationObject(parameters, USERNAME_PROPERTY);
        this.password = DBConnectionFactoryHelper.getNullOrStringValueFromConfigurationObject(parameters, PASSWORD_PROPERTY);
    }

    public DataSourceConnectionProducer(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public DataSourceConnectionProducer(DataSource dataSource, String username, String password) {
        this(dataSource);
        this.username = username;
        this.password = password;
    }

    public synchronized Connection createConnection() throws DBConnectionException {
        return this.createConnection(this.username, this.password);
    }

    public synchronized Connection createConnection(String username, String password) throws DBConnectionException {
        if (this.dataSource == null) {
            throw new DBConnectionException("The dataSource hadn't been configured yet", new IllegalStateException("The status is invalid for calling createConnection"));
        }
        try {
            return username == null && password == null ? this.dataSource.getConnection() : this.dataSource.getConnection(username, password);
        }
        catch (SQLException sqle) {
            throw new DBConnectionException("Error occurs while creating connection", sqle);
        }
    }

    public synchronized DataSource getDataSource() {
        return this.dataSource;
    }

    protected synchronized void setDataSource(DataSource dataSource) {
        DBConnectionFactoryHelper.checkNull("dataSource", dataSource);
        this.dataSource = dataSource;
    }

    protected synchronized void setUsername(String username) {
        DBConnectionFactoryHelper.checkNull(USERNAME_PROPERTY, username);
        this.username = username;
    }

    protected synchronized void setPassword(String password) {
        DBConnectionFactoryHelper.checkNull(PASSWORD_PROPERTY, password);
        this.password = password;
    }
}

