/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.db.connectionfactory;

import com.topcoder.configuration.ConfigurationAccessException;
import com.topcoder.configuration.ConfigurationObject;
import com.topcoder.db.connectionfactory.ConfigurationException;
import com.topcoder.db.connectionfactory.ConnectionProducer;
import com.topcoder.db.connectionfactory.DBConnectionException;
import com.topcoder.db.connectionfactory.DBConnectionFactory;
import com.topcoder.db.connectionfactory.DBConnectionFactoryHelper;
import com.topcoder.db.connectionfactory.NoDefaultConnectionException;
import com.topcoder.db.connectionfactory.UnknownConnectionException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownNamespaceException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBConnectionFactoryImpl
implements DBConnectionFactory {
    public static final String DEFAULT_NAMESPACE = (class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl == null ? (class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl = DBConnectionFactoryImpl.class$("com.topcoder.db.connectionfactory.DBConnectionFactoryImpl")) : class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl).getName();
    private static final Class[] PROPERTY_CLASS_ARRAY = new Class[]{class$com$topcoder$util$config$Property == null ? (class$com$topcoder$util$config$Property = DBConnectionFactoryImpl.class$("com.topcoder.util.config.Property")) : class$com$topcoder$util$config$Property};
    private static final Class[] CONFIGURATIONOBJECT_CLASS_ARRAY = new Class[]{class$com$topcoder$configuration$ConfigurationObject == null ? (class$com$topcoder$configuration$ConfigurationObject = DBConnectionFactoryImpl.class$("com.topcoder.configuration.ConfigurationObject")) : class$com$topcoder$configuration$ConfigurationObject};
    private static final String CONNECTIONS = "connections";
    private static final String DEFAULT = "default";
    private static final String PRODUCER = "producer";
    private static final String PARAMETERS = "parameters";
    private final Map connectionProducers = new HashMap();
    private String defaultProducerName = null;
    static /* synthetic */ Class class$com$topcoder$db$connectionfactory$DBConnectionFactoryImpl;
    static /* synthetic */ Class class$com$topcoder$util$config$Property;
    static /* synthetic */ Class class$com$topcoder$configuration$ConfigurationObject;

    public DBConnectionFactoryImpl() {
    }

    public DBConnectionFactoryImpl(String namespace) throws ConfigurationException, UnknownConnectionException {
        DBConnectionFactoryHelper.checkNullOrEmpty("namespace", namespace);
        String defaultProducer = null;
        try {
            ConfigManager cm = ConfigManager.getInstance();
            if (!cm.existsNamespace(namespace)) {
                throw new UnknownNamespaceException("The namespace is not defined in the ConfigManager.");
            }
            cm.refresh(namespace);
            List list = cm.getPropertyObject(namespace, CONNECTIONS).list();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Property property = (Property)it.next();
                String name = property.getName();
                if (name.equals(DEFAULT)) {
                    defaultProducer = property.getValue();
                    continue;
                }
                String producerClassName = property.getValue(PRODUCER);
                Property parameters = property.getProperty(PARAMETERS);
                ConnectionProducer producer = (ConnectionProducer)DBConnectionFactoryImpl.createObject(producerClassName, PROPERTY_CLASS_ARRAY, new Object[]{parameters});
                this.add(name, producer);
            }
        }
        catch (ConfigManagerException cme) {
            throw new ConfigurationException("Error occurs in the ConfigManager- ", cme);
        }
        catch (InstantiationException ie) {
            throw new ConfigurationException("Error occurs when creating the producer- ", ie);
        }
        catch (IllegalAccessException iae) {
            throw new ConfigurationException("Error occurs when creating the producer- ", iae);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("The configured class name can not be found- ", cnfe);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unexpected errors- ", ex);
        }
        if (defaultProducer != null) {
            if (defaultProducer.trim().length() == 0) {
                throw new ConfigurationException("The value for property [default] should not be empty string.");
            }
            this.setDefault(defaultProducer);
        }
    }

    public DBConnectionFactoryImpl(ConfigurationObject configurationObject) throws ConfigurationException, UnknownConnectionException {
        this(configurationObject, DEFAULT_NAMESPACE);
    }

    public DBConnectionFactoryImpl(ConfigurationObject configurationObject, String namespace) throws ConfigurationException, UnknownConnectionException {
        DBConnectionFactoryHelper.checkNull("configurationObject", configurationObject);
        DBConnectionFactoryHelper.checkNullOrEmpty("namespace", namespace);
        try {
            ConfigurationObject childObject = configurationObject.getChild(namespace);
            if (childObject == null) {
                throw new ConfigurationException("There is no child ConfigurationObject with given name[" + namespace + "] in the given configurationObject");
            }
            ConfigurationObject connectionObject = childObject.getChild(CONNECTIONS);
            if (connectionObject == null) {
                throw new ConfigurationException("There is no child ConfigurationObject with given name[connections] in the [" + namespace + "] ConfigurationObject");
            }
            ConfigurationObject[] allProducers = connectionObject.getAllChildren();
            for (int i = 0; i < allProducers.length; ++i) {
                Object producerValue = allProducers[i].getPropertyValue(PRODUCER);
                if (!(producerValue instanceof String)) {
                    throw new ConfigurationException("The value of property [producer] should exist as String.");
                }
                ConnectionProducer producer = (ConnectionProducer)DBConnectionFactoryImpl.createObject((String)producerValue, CONFIGURATIONOBJECT_CLASS_ARRAY, new Object[]{allProducers[i]});
                this.add(allProducers[i].getName(), producer);
            }
            Object deaultValue = connectionObject.getPropertyValue(DEFAULT);
            if (deaultValue instanceof String) {
                String deaultStringValue = (String)deaultValue;
                if (deaultStringValue.trim().length() == 0) {
                    throw new ConfigurationException("The value of property[default] should be not be empty String.");
                }
                this.setDefault(deaultStringValue);
            } else if (deaultValue != null) {
                throw new ConfigurationException("The value of property[default] should be String if it is not null.");
            }
        }
        catch (ConfigurationAccessException cae) {
            throw new ConfigurationException("Error occurs while access configuration", cae);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", cnfe);
        }
        catch (SecurityException se) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", se);
        }
        catch (NoSuchMethodException nsme) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", nsme);
        }
        catch (InstantiationException ie) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", ie);
        }
        catch (IllegalAccessException iae) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", iae);
        }
        catch (InvocationTargetException ite) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", ite);
        }
        catch (ClassCastException cce) {
            throw new ConfigurationException("The created instance is not of ConnectionProducer", cce);
        }
        catch (ExceptionInInitializerError eiie) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", eiie);
        }
        catch (LinkageError le) {
            throw new ConfigurationException("Error occurs while creating ConnectionProducer", le);
        }
    }

    private static Object createObject(String className, Class[] paramClassArray, Object[] paramArray) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> theClass = Class.forName(className);
        Constructor<?> constructor = theClass.getConstructor(paramClassArray);
        return constructor.newInstance(paramArray);
    }

    public synchronized Connection createConnection() throws NoDefaultConnectionException, DBConnectionException {
        Object producer = this.connectionProducers.get(this.defaultProducerName);
        if (producer == null) {
            throw new NoDefaultConnectionException("The default connection producer is not configured to this factory.");
        }
        return ((ConnectionProducer)producer).createConnection();
    }

    public synchronized Connection createConnection(String name) throws UnknownConnectionException, DBConnectionException {
        DBConnectionFactoryHelper.checkNullOrEmpty("name", name);
        Object conn = this.connectionProducers.get(name);
        if (conn == null) {
            throw new UnknownConnectionException(name, "Can not retrieve the ConnectionProducer via " + name);
        }
        return ((ConnectionProducer)conn).createConnection();
    }

    public synchronized Connection createConnection(String username, String password) throws NoDefaultConnectionException, DBConnectionException {
        Object producer = this.connectionProducers.get(this.defaultProducerName);
        if (producer == null) {
            throw new NoDefaultConnectionException("The default connection producer is not configured within this factory.");
        }
        return ((ConnectionProducer)producer).createConnection(username, password);
    }

    public synchronized Connection createConnection(String name, String username, String password) throws UnknownConnectionException, DBConnectionException {
        DBConnectionFactoryHelper.checkNullOrEmpty("name", name);
        Object conn = this.connectionProducers.get(name);
        if (conn == null) {
            throw new UnknownConnectionException(name, "Can not retrieve the ConnectionProducer via " + name);
        }
        return ((ConnectionProducer)conn).createConnection(username, password);
    }

    public synchronized boolean add(String name, ConnectionProducer producer) {
        DBConnectionFactoryHelper.checkNullOrEmpty("name", name);
        DBConnectionFactoryHelper.checkNull(PRODUCER, producer);
        if (this.connectionProducers.containsKey(name)) {
            return false;
        }
        this.connectionProducers.put(name, producer);
        return true;
    }

    public synchronized ConnectionProducer remove(String name) {
        DBConnectionFactoryHelper.checkNullOrEmpty("name", name);
        if (name.equals(this.defaultProducerName)) {
            this.defaultProducerName = null;
        }
        return (ConnectionProducer)this.connectionProducers.remove(name);
    }

    public synchronized boolean contains(String name) {
        DBConnectionFactoryHelper.checkNullOrEmpty("name", name);
        return this.connectionProducers.containsKey(name);
    }

    public synchronized String getDefault() {
        return this.defaultProducerName;
    }

    public synchronized void setDefault(String name) throws UnknownConnectionException {
        if (name == null) {
            this.defaultProducerName = null;
            return;
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("The name should not be empty.");
        }
        if (!this.connectionProducers.containsKey(name)) {
            throw new UnknownConnectionException(name, "The name [" + name + "] does not exist in connectionProducers.");
        }
        this.defaultProducerName = name;
    }

    public synchronized Iterator listConnectionProducerNames() {
        return this.connectionProducers.keySet().iterator();
    }

    public synchronized ConnectionProducer get(String name) {
        DBConnectionFactoryHelper.checkNullOrEmpty("name", name);
        return (ConnectionProducer)this.connectionProducers.get(name);
    }

    public synchronized void clear() {
        this.connectionProducers.clear();
        this.defaultProducerName = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

