/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.db.connectionfactory;

import com.topcoder.configuration.ConfigurationAccessException;
import com.topcoder.configuration.ConfigurationObject;

public final class DBConnectionFactoryHelper {
    private DBConnectionFactoryHelper() {
    }

    public static void checkNull(String paramName, Object paramValue) {
        if (paramValue == null) {
            throw new IllegalArgumentException("The " + paramName + " should be not null.");
        }
    }

    public static void checkNullOrEmpty(String paramName, String paramValue) {
        DBConnectionFactoryHelper.checkNull(paramName, paramValue);
        if (paramValue.trim().length() == 0) {
            throw new IllegalArgumentException("The " + paramName + " should not be empty.");
        }
    }

    public static ConfigurationObject getChildFromConfigurationObject(String name, ConfigurationObject configurationObject, String key) throws ConfigurationAccessException {
        DBConnectionFactoryHelper.checkNull(name, configurationObject);
        DBConnectionFactoryHelper.checkNullOrEmpty("key", key);
        ConfigurationObject child = configurationObject.getChild(key);
        if (child == null) {
            throw new IllegalArgumentException("ConfigurationObject child for name[" + key + "] does not exit.");
        }
        return child;
    }

    public static String getNullOrStringValueFromConfigurationObject(ConfigurationObject configurationObject, String key) throws ConfigurationAccessException {
        DBConnectionFactoryHelper.checkNull("configurationObject", configurationObject);
        DBConnectionFactoryHelper.checkNullOrEmpty("key", key);
        Object value = configurationObject.getPropertyValue(key);
        if (value != null && !(value instanceof String)) {
            throw new IllegalArgumentException("The value of property [" + key + "] should not be non-null non-String object.");
        }
        return (String)value;
    }
}

